/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum CollectionType {
    NON_FUNGIBLE_TOKEN("NON_FUNGIBLE_TOKEN"),
    SEMI_FUNGIBLE_TOKEN("SEMI_FUNGIBLE_TOKEN");

    private String value;

    private CollectionType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static CollectionType fromValue(String value) {
        for (CollectionType b : CollectionType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

