/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"provider", "payload", "bypassReason", "screeningStatus", "timestamp"})
public class ComplianceScreeningResult {
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private String provider;
    public static final String JSON_PROPERTY_PAYLOAD = "payload";
    private Object payload;
    public static final String JSON_PROPERTY_BYPASS_REASON = "bypassReason";
    private String bypassReason;
    public static final String JSON_PROPERTY_SCREENING_STATUS = "screeningStatus";
    private ScreeningStatusEnum screeningStatus;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private BigDecimal timestamp;

    public ComplianceScreeningResult provider(String provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(String provider) {
        this.provider = provider;
    }

    public ComplianceScreeningResult payload(Object payload) {
        this.payload = payload;
        return this;
    }

    @Nullable
    @JsonProperty(value="payload")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getPayload() {
        return this.payload;
    }

    @JsonProperty(value="payload")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayload(Object payload) {
        this.payload = payload;
    }

    public ComplianceScreeningResult bypassReason(String bypassReason) {
        this.bypassReason = bypassReason;
        return this;
    }

    @Nullable
    @JsonProperty(value="bypassReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBypassReason() {
        return this.bypassReason;
    }

    @JsonProperty(value="bypassReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBypassReason(String bypassReason) {
        this.bypassReason = bypassReason;
    }

    public ComplianceScreeningResult screeningStatus(ScreeningStatusEnum screeningStatus) {
        this.screeningStatus = screeningStatus;
        return this;
    }

    @Nullable
    @JsonProperty(value="screeningStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScreeningStatusEnum getScreeningStatus() {
        return this.screeningStatus;
    }

    @JsonProperty(value="screeningStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScreeningStatus(ScreeningStatusEnum screeningStatus) {
        this.screeningStatus = screeningStatus;
    }

    public ComplianceScreeningResult timestamp(BigDecimal timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimestamp(BigDecimal timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplianceScreeningResult complianceScreeningResult = (ComplianceScreeningResult)o;
        return Objects.equals(this.provider, complianceScreeningResult.provider) && Objects.equals(this.payload, complianceScreeningResult.payload) && Objects.equals(this.bypassReason, complianceScreeningResult.bypassReason) && Objects.equals((Object)this.screeningStatus, (Object)complianceScreeningResult.screeningStatus) && Objects.equals(this.timestamp, complianceScreeningResult.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.provider, this.payload, this.bypassReason, this.screeningStatus, this.timestamp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ComplianceScreeningResult {\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    bypassReason: ").append(this.toIndentedString(this.bypassReason)).append("\n");
        sb.append("    screeningStatus: ").append(this.toIndentedString((Object)this.screeningStatus)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getProvider() != null) {
            joiner.add(String.format("%sprovider%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProvider()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPayload() != null) {
            joiner.add(String.format("%spayload%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPayload()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getBypassReason() != null) {
            joiner.add(String.format("%sbypassReason%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBypassReason()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getScreeningStatus() != null) {
            joiner.add(String.format("%sscreeningStatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getScreeningStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTimestamp() != null) {
            joiner.add(String.format("%stimestamp%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTimestamp()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum ScreeningStatusEnum {
        COMPLETED("COMPLETED"),
        PENDING("PENDING"),
        BYPASSED("BYPASSED"),
        FAILED("FAILED"),
        FROZEN("FROZEN");

        private String value;

        private ScreeningStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScreeningStatusEnum fromValue(String value) {
            for (ScreeningStatusEnum b : ScreeningStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

