/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.AuditorData;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"useCases", "standards", "auditor"})
public class ContractAttributes {
    public static final String JSON_PROPERTY_USE_CASES = "useCases";
    private List<String> useCases = new ArrayList<String>();
    public static final String JSON_PROPERTY_STANDARDS = "standards";
    private List<String> standards = new ArrayList<String>();
    public static final String JSON_PROPERTY_AUDITOR = "auditor";
    private AuditorData auditor;

    public ContractAttributes useCases(List<String> useCases) {
        this.useCases = useCases;
        return this;
    }

    public ContractAttributes addUseCasesItem(String useCasesItem) {
        if (this.useCases == null) {
            this.useCases = new ArrayList<String>();
        }
        this.useCases.add(useCasesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="useCases")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getUseCases() {
        return this.useCases;
    }

    @JsonProperty(value="useCases")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUseCases(List<String> useCases) {
        this.useCases = useCases;
    }

    public ContractAttributes standards(List<String> standards) {
        this.standards = standards;
        return this;
    }

    public ContractAttributes addStandardsItem(String standardsItem) {
        if (this.standards == null) {
            this.standards = new ArrayList<String>();
        }
        this.standards.add(standardsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="standards")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getStandards() {
        return this.standards;
    }

    @JsonProperty(value="standards")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStandards(List<String> standards) {
        this.standards = standards;
    }

    public ContractAttributes auditor(AuditorData auditor) {
        this.auditor = auditor;
        return this;
    }

    @Nonnull
    @JsonProperty(value="auditor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AuditorData getAuditor() {
        return this.auditor;
    }

    @JsonProperty(value="auditor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAuditor(AuditorData auditor) {
        this.auditor = auditor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractAttributes contractAttributes = (ContractAttributes)o;
        return Objects.equals(this.useCases, contractAttributes.useCases) && Objects.equals(this.standards, contractAttributes.standards) && Objects.equals(this.auditor, contractAttributes.auditor);
    }

    public int hashCode() {
        return Objects.hash(this.useCases, this.standards, this.auditor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContractAttributes {\n");
        sb.append("    useCases: ").append(this.toIndentedString(this.useCases)).append("\n");
        sb.append("    standards: ").append(this.toIndentedString(this.standards)).append("\n");
        sb.append("    auditor: ").append(this.toIndentedString(this.auditor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getUseCases() != null) {
            for (i = 0; i < this.getUseCases().size(); ++i) {
                joiner.add(String.format("%suseCases%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getUseCases().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getStandards() != null) {
            for (i = 0; i < this.getStandards().size(); ++i) {
                joiner.add(String.format("%sstandards%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getStandards().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getAuditor() != null) {
            joiner.add(this.getAuditor().toUrlQueryString((String)prefix + JSON_PROPERTY_AUDITOR + suffix));
        }
        return joiner.toString();
    }
}

