/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.ParameterWithValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"assetId", "vaultAccountId", "constructorParameters"})
public class ContractDeployRequest {
    public static final String JSON_PROPERTY_ASSET_ID = "assetId";
    private String assetId;
    public static final String JSON_PROPERTY_VAULT_ACCOUNT_ID = "vaultAccountId";
    private String vaultAccountId;
    public static final String JSON_PROPERTY_CONSTRUCTOR_PARAMETERS = "constructorParameters";
    private List<ParameterWithValue> constructorParameters;

    public ContractDeployRequest assetId(String assetId) {
        this.assetId = assetId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="assetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAssetId() {
        return this.assetId;
    }

    @JsonProperty(value="assetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public ContractDeployRequest vaultAccountId(String vaultAccountId) {
        this.vaultAccountId = vaultAccountId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="vaultAccountId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVaultAccountId() {
        return this.vaultAccountId;
    }

    @JsonProperty(value="vaultAccountId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVaultAccountId(String vaultAccountId) {
        this.vaultAccountId = vaultAccountId;
    }

    public ContractDeployRequest constructorParameters(List<ParameterWithValue> constructorParameters) {
        this.constructorParameters = constructorParameters;
        return this;
    }

    public ContractDeployRequest addConstructorParametersItem(ParameterWithValue constructorParametersItem) {
        if (this.constructorParameters == null) {
            this.constructorParameters = new ArrayList<ParameterWithValue>();
        }
        this.constructorParameters.add(constructorParametersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="constructorParameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ParameterWithValue> getConstructorParameters() {
        return this.constructorParameters;
    }

    @JsonProperty(value="constructorParameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConstructorParameters(List<ParameterWithValue> constructorParameters) {
        this.constructorParameters = constructorParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractDeployRequest contractDeployRequest = (ContractDeployRequest)o;
        return Objects.equals(this.assetId, contractDeployRequest.assetId) && Objects.equals(this.vaultAccountId, contractDeployRequest.vaultAccountId) && Objects.equals(this.constructorParameters, contractDeployRequest.constructorParameters);
    }

    public int hashCode() {
        return Objects.hash(this.assetId, this.vaultAccountId, this.constructorParameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContractDeployRequest {\n");
        sb.append("    assetId: ").append(this.toIndentedString(this.assetId)).append("\n");
        sb.append("    vaultAccountId: ").append(this.toIndentedString(this.vaultAccountId)).append("\n");
        sb.append("    constructorParameters: ").append(this.toIndentedString(this.constructorParameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAssetId() != null) {
            joiner.add(String.format("%sassetId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAssetId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getVaultAccountId() != null) {
            joiner.add(String.format("%svaultAccountId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVaultAccountId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getConstructorParameters() != null) {
            for (int i = 0; i < this.getConstructorParameters().size(); ++i) {
                if (this.getConstructorParameters().get(i) == null) continue;
                joiner.add(this.getConstructorParameters().get(i).toUrlQueryString(String.format("%sconstructorParameters%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

