/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.FunctionDoc;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"details", "events", "kind", "methods", "version"})
public class ContractDoc {
    public static final String JSON_PROPERTY_DETAILS = "details";
    private String details;
    public static final String JSON_PROPERTY_EVENTS = "events";
    private String events;
    public static final String JSON_PROPERTY_KIND = "kind";
    private String kind;
    public static final String JSON_PROPERTY_METHODS = "methods";
    private Map<String, FunctionDoc> methods = new HashMap<String, FunctionDoc>();
    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;

    public ContractDoc details(String details) {
        this.details = details;
        return this;
    }

    @Nullable
    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDetails() {
        return this.details;
    }

    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDetails(String details) {
        this.details = details;
    }

    public ContractDoc events(String events) {
        this.events = events;
        return this;
    }

    @Nullable
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEvents() {
        return this.events;
    }

    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEvents(String events) {
        this.events = events;
    }

    public ContractDoc kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKind(String kind) {
        this.kind = kind;
    }

    public ContractDoc methods(Map<String, FunctionDoc> methods) {
        this.methods = methods;
        return this;
    }

    public ContractDoc putMethodsItem(String key, FunctionDoc methodsItem) {
        if (this.methods == null) {
            this.methods = new HashMap<String, FunctionDoc>();
        }
        this.methods.put(key, methodsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="methods")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Map<String, FunctionDoc> getMethods() {
        return this.methods;
    }

    @JsonProperty(value="methods")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMethods(Map<String, FunctionDoc> methods) {
        this.methods = methods;
    }

    public ContractDoc version(String version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractDoc contractDoc = (ContractDoc)o;
        return Objects.equals(this.details, contractDoc.details) && Objects.equals(this.events, contractDoc.events) && Objects.equals(this.kind, contractDoc.kind) && Objects.equals(this.methods, contractDoc.methods) && Objects.equals(this.version, contractDoc.version);
    }

    public int hashCode() {
        return Objects.hash(this.details, this.events, this.kind, this.methods, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContractDoc {\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    methods: ").append(this.toIndentedString(this.methods)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getDetails() != null) {
            joiner.add(String.format("%sdetails%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDetails()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getEvents() != null) {
            joiner.add(String.format("%sevents%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEvents()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getKind() != null) {
            joiner.add(String.format("%skind%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getKind()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getMethods() != null) {
            for (String _key : this.getMethods().keySet()) {
                if (this.getMethods().get(_key) == null) continue;
                joiner.add(this.getMethods().get(_key).toUrlQueryString(String.format("%smethods%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getVersion() != null) {
            joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVersion()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

