/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fireblocks.sdk.model.AbiFunction;
import com.fireblocks.sdk.model.ContractAttributes;
import com.fireblocks.sdk.model.ContractDoc;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "description", "longDescription", "bytecode", "sourcecode", "type", "docs", "abi", "attributes"})
public class ContractUploadRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_LONG_DESCRIPTION = "longDescription";
    private String longDescription;
    public static final String JSON_PROPERTY_BYTECODE = "bytecode";
    private String bytecode;
    public static final String JSON_PROPERTY_SOURCECODE = "sourcecode";
    private String sourcecode;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_DOCS = "docs";
    private ContractDoc docs;
    public static final String JSON_PROPERTY_ABI = "abi";
    private List<List<AbiFunction>> abi = new ArrayList<List<AbiFunction>>();
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private ContractAttributes attributes;

    public ContractUploadRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public ContractUploadRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public ContractUploadRequest longDescription(String longDescription) {
        this.longDescription = longDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="longDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLongDescription() {
        return this.longDescription;
    }

    @JsonProperty(value="longDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    public ContractUploadRequest bytecode(String bytecode) {
        this.bytecode = bytecode;
        return this;
    }

    @Nonnull
    @JsonProperty(value="bytecode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBytecode() {
        return this.bytecode;
    }

    @JsonProperty(value="bytecode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBytecode(String bytecode) {
        this.bytecode = bytecode;
    }

    public ContractUploadRequest sourcecode(String sourcecode) {
        this.sourcecode = sourcecode;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourcecode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourcecode() {
        return this.sourcecode;
    }

    @JsonProperty(value="sourcecode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourcecode(String sourcecode) {
        this.sourcecode = sourcecode;
    }

    public ContractUploadRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ContractUploadRequest docs(ContractDoc docs) {
        this.docs = docs;
        return this;
    }

    @Nullable
    @JsonProperty(value="docs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContractDoc getDocs() {
        return this.docs;
    }

    @JsonProperty(value="docs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocs(ContractDoc docs) {
        this.docs = docs;
    }

    public ContractUploadRequest abi(List<List<AbiFunction>> abi) {
        this.abi = abi;
        return this;
    }

    public ContractUploadRequest addAbiItem(List<AbiFunction> abiItem) {
        if (this.abi == null) {
            this.abi = new ArrayList<List<AbiFunction>>();
        }
        this.abi.add(abiItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="abi")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<List<AbiFunction>> getAbi() {
        return this.abi;
    }

    @JsonProperty(value="abi")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAbi(List<List<AbiFunction>> abi) {
        this.abi = abi;
    }

    public ContractUploadRequest attributes(ContractAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContractAttributes getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttributes(ContractAttributes attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractUploadRequest contractUploadRequest = (ContractUploadRequest)o;
        return Objects.equals(this.name, contractUploadRequest.name) && Objects.equals(this.description, contractUploadRequest.description) && Objects.equals(this.longDescription, contractUploadRequest.longDescription) && Objects.equals(this.bytecode, contractUploadRequest.bytecode) && Objects.equals(this.sourcecode, contractUploadRequest.sourcecode) && Objects.equals((Object)this.type, (Object)contractUploadRequest.type) && Objects.equals(this.docs, contractUploadRequest.docs) && Objects.equals(this.abi, contractUploadRequest.abi) && Objects.equals(this.attributes, contractUploadRequest.attributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.longDescription, this.bytecode, this.sourcecode, this.type, this.docs, this.abi, this.attributes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContractUploadRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    longDescription: ").append(this.toIndentedString(this.longDescription)).append("\n");
        sb.append("    bytecode: ").append(this.toIndentedString(this.bytecode)).append("\n");
        sb.append("    sourcecode: ").append(this.toIndentedString(this.sourcecode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    docs: ").append(this.toIndentedString(this.docs)).append("\n");
        sb.append("    abi: ").append(this.toIndentedString(this.abi)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDescription() != null) {
            joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getLongDescription() != null) {
            joiner.add(String.format("%slongDescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLongDescription()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getBytecode() != null) {
            joiner.add(String.format("%sbytecode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBytecode()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSourcecode() != null) {
            joiner.add(String.format("%ssourcecode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSourcecode()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDocs() != null) {
            joiner.add(this.getDocs().toUrlQueryString((String)prefix + JSON_PROPERTY_DOCS + suffix));
        }
        if (this.getAbi() != null) {
            for (int i = 0; i < this.getAbi().size(); ++i) {
                if (this.getAbi().get(i) == null) continue;
                joiner.add(String.format("%sabi%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getAbi().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getAttributes() != null) {
            joiner.add(this.getAttributes().toUrlQueryString((String)prefix + JSON_PROPERTY_ATTRIBUTES + suffix));
        }
        return joiner.toString();
    }

    public static enum TypeEnum {
        FUNGIBLE_TOKEN("FUNGIBLE_TOKEN"),
        NON_FUNGIBLE_TOKEN("NON_FUNGIBLE_TOKEN"),
        NON_TOKEN("NON_TOKEN"),
        TOKEN_EXTENSION("TOKEN_EXTENSION"),
        TOKEN_UTILITY("TOKEN_UTILITY");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

