/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.ConfigOperationStatus;
import com.fireblocks.sdk.model.ConversionOperationConfigParams;
import com.fireblocks.sdk.model.ConversionOperationType;
import com.fireblocks.sdk.model.ConversionValidationFailure;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"operationId", "type", "params", "status", "validationFailure"})
public class ConversionConfigOperation {
    public static final String JSON_PROPERTY_OPERATION_ID = "operationId";
    private String operationId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ConversionOperationType type;
    public static final String JSON_PROPERTY_PARAMS = "params";
    private ConversionOperationConfigParams params;
    public static final String JSON_PROPERTY_STATUS = "status";
    private ConfigOperationStatus status;
    public static final String JSON_PROPERTY_VALIDATION_FAILURE = "validationFailure";
    private ConversionValidationFailure validationFailure;

    public ConversionConfigOperation operationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="operationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOperationId() {
        return this.operationId;
    }

    @JsonProperty(value="operationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public ConversionConfigOperation type(ConversionOperationType type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConversionOperationType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(ConversionOperationType type) {
        this.type = type;
    }

    public ConversionConfigOperation params(ConversionOperationConfigParams params) {
        this.params = params;
        return this;
    }

    @Nonnull
    @JsonProperty(value="params")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConversionOperationConfigParams getParams() {
        return this.params;
    }

    @JsonProperty(value="params")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setParams(ConversionOperationConfigParams params) {
        this.params = params;
    }

    public ConversionConfigOperation status(ConfigOperationStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConfigOperationStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(ConfigOperationStatus status) {
        this.status = status;
    }

    public ConversionConfigOperation validationFailure(ConversionValidationFailure validationFailure) {
        this.validationFailure = validationFailure;
        return this;
    }

    @Nullable
    @JsonProperty(value="validationFailure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConversionValidationFailure getValidationFailure() {
        return this.validationFailure;
    }

    @JsonProperty(value="validationFailure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValidationFailure(ConversionValidationFailure validationFailure) {
        this.validationFailure = validationFailure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversionConfigOperation conversionConfigOperation = (ConversionConfigOperation)o;
        return Objects.equals(this.operationId, conversionConfigOperation.operationId) && Objects.equals((Object)this.type, (Object)conversionConfigOperation.type) && Objects.equals(this.params, conversionConfigOperation.params) && Objects.equals((Object)this.status, (Object)conversionConfigOperation.status) && Objects.equals(this.validationFailure, conversionConfigOperation.validationFailure);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operationId, this.type, this.params, this.status, this.validationFailure});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversionConfigOperation {\n");
        sb.append("    operationId: ").append(this.toIndentedString(this.operationId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    params: ").append(this.toIndentedString(this.params)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    validationFailure: ").append(this.toIndentedString(this.validationFailure)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getOperationId() != null) {
            joiner.add(String.format("%soperationId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getOperationId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getParams() != null) {
            joiner.add(this.getParams().toUrlQueryString((String)prefix + JSON_PROPERTY_PARAMS + suffix));
        }
        if (this.getStatus() != null) {
            joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getValidationFailure() != null) {
            joiner.add(this.getValidationFailure().toUrlQueryString((String)prefix + JSON_PROPERTY_VALIDATION_FAILURE + suffix));
        }
        return joiner.toString();
    }
}

