/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.AssetAmount;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"amount", "fee", "conversionRate", "timeSeconds"})
public class ConversionOperationPreviewOutput {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private AssetAmount amount;
    public static final String JSON_PROPERTY_FEE = "fee";
    private AssetAmount fee;
    public static final String JSON_PROPERTY_CONVERSION_RATE = "conversionRate";
    private String conversionRate;
    public static final String JSON_PROPERTY_TIME_SECONDS = "timeSeconds";
    private BigDecimal timeSeconds;

    public ConversionOperationPreviewOutput amount(AssetAmount amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AssetAmount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(AssetAmount amount) {
        this.amount = amount;
    }

    public ConversionOperationPreviewOutput fee(AssetAmount fee) {
        this.fee = fee;
        return this;
    }

    @Nonnull
    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AssetAmount getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFee(AssetAmount fee) {
        this.fee = fee;
    }

    public ConversionOperationPreviewOutput conversionRate(String conversionRate) {
        this.conversionRate = conversionRate;
        return this;
    }

    @Nonnull
    @JsonProperty(value="conversionRate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getConversionRate() {
        return this.conversionRate;
    }

    @JsonProperty(value="conversionRate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConversionRate(String conversionRate) {
        this.conversionRate = conversionRate;
    }

    public ConversionOperationPreviewOutput timeSeconds(BigDecimal timeSeconds) {
        this.timeSeconds = timeSeconds;
        return this;
    }

    @Nonnull
    @JsonProperty(value="timeSeconds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getTimeSeconds() {
        return this.timeSeconds;
    }

    @JsonProperty(value="timeSeconds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTimeSeconds(BigDecimal timeSeconds) {
        this.timeSeconds = timeSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversionOperationPreviewOutput conversionOperationPreviewOutput = (ConversionOperationPreviewOutput)o;
        return Objects.equals(this.amount, conversionOperationPreviewOutput.amount) && Objects.equals(this.fee, conversionOperationPreviewOutput.fee) && Objects.equals(this.conversionRate, conversionOperationPreviewOutput.conversionRate) && Objects.equals(this.timeSeconds, conversionOperationPreviewOutput.timeSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.fee, this.conversionRate, this.timeSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversionOperationPreviewOutput {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    conversionRate: ").append(this.toIndentedString(this.conversionRate)).append("\n");
        sb.append("    timeSeconds: ").append(this.toIndentedString(this.timeSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAmount() != null) {
            joiner.add(this.getAmount().toUrlQueryString((String)prefix + JSON_PROPERTY_AMOUNT + suffix));
        }
        if (this.getFee() != null) {
            joiner.add(this.getFee().toUrlQueryString((String)prefix + JSON_PROPERTY_FEE + suffix));
        }
        if (this.getConversionRate() != null) {
            joiner.add(String.format("%sconversionRate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getConversionRate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTimeSeconds() != null) {
            joiner.add(String.format("%stimeSeconds%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTimeSeconds()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

