/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"srcAsset", "destAsset", "amount"})
public class ConvertAssetsRequest {
    public static final String JSON_PROPERTY_SRC_ASSET = "srcAsset";
    private String srcAsset;
    public static final String JSON_PROPERTY_DEST_ASSET = "destAsset";
    private String destAsset;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private BigDecimal amount;

    public ConvertAssetsRequest srcAsset(String srcAsset) {
        this.srcAsset = srcAsset;
        return this;
    }

    @Nonnull
    @JsonProperty(value="srcAsset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSrcAsset() {
        return this.srcAsset;
    }

    @JsonProperty(value="srcAsset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSrcAsset(String srcAsset) {
        this.srcAsset = srcAsset;
    }

    public ConvertAssetsRequest destAsset(String destAsset) {
        this.destAsset = destAsset;
        return this;
    }

    @Nonnull
    @JsonProperty(value="destAsset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDestAsset() {
        return this.destAsset;
    }

    @JsonProperty(value="destAsset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDestAsset(String destAsset) {
        this.destAsset = destAsset;
    }

    public ConvertAssetsRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConvertAssetsRequest convertAssetsRequest = (ConvertAssetsRequest)o;
        return Objects.equals(this.srcAsset, convertAssetsRequest.srcAsset) && Objects.equals(this.destAsset, convertAssetsRequest.destAsset) && Objects.equals(this.amount, convertAssetsRequest.amount);
    }

    public int hashCode() {
        return Objects.hash(this.srcAsset, this.destAsset, this.amount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConvertAssetsRequest {\n");
        sb.append("    srcAsset: ").append(this.toIndentedString(this.srcAsset)).append("\n");
        sb.append("    destAsset: ").append(this.toIndentedString(this.destAsset)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSrcAsset() != null) {
            joiner.add(String.format("%ssrcAsset%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSrcAsset()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDestAsset() != null) {
            joiner.add(String.format("%sdestAsset%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDestAsset()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAmount() != null) {
            joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

