/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"role", "name", "csrPem", "coSignerSetupType", "coSignerSetupIsFirstUser"})
public class CreateAPIUser {
    public static final String JSON_PROPERTY_ROLE = "role";
    private String role;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_CSR_PEM = "csrPem";
    private String csrPem;
    public static final String JSON_PROPERTY_CO_SIGNER_SETUP_TYPE = "coSignerSetupType";
    private String coSignerSetupType;
    public static final String JSON_PROPERTY_CO_SIGNER_SETUP_IS_FIRST_USER = "coSignerSetupIsFirstUser";
    private Boolean coSignerSetupIsFirstUser;

    public CreateAPIUser role(String role) {
        this.role = role;
        return this;
    }

    @Nonnull
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRole(String role) {
        this.role = role;
    }

    public CreateAPIUser name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateAPIUser csrPem(String csrPem) {
        this.csrPem = csrPem;
        return this;
    }

    @Nonnull
    @JsonProperty(value="csrPem")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCsrPem() {
        return this.csrPem;
    }

    @JsonProperty(value="csrPem")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCsrPem(String csrPem) {
        this.csrPem = csrPem;
    }

    public CreateAPIUser coSignerSetupType(String coSignerSetupType) {
        this.coSignerSetupType = coSignerSetupType;
        return this;
    }

    @Nullable
    @JsonProperty(value="coSignerSetupType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCoSignerSetupType() {
        return this.coSignerSetupType;
    }

    @JsonProperty(value="coSignerSetupType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCoSignerSetupType(String coSignerSetupType) {
        this.coSignerSetupType = coSignerSetupType;
    }

    public CreateAPIUser coSignerSetupIsFirstUser(Boolean coSignerSetupIsFirstUser) {
        this.coSignerSetupIsFirstUser = coSignerSetupIsFirstUser;
        return this;
    }

    @Nullable
    @JsonProperty(value="coSignerSetupIsFirstUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCoSignerSetupIsFirstUser() {
        return this.coSignerSetupIsFirstUser;
    }

    @JsonProperty(value="coSignerSetupIsFirstUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCoSignerSetupIsFirstUser(Boolean coSignerSetupIsFirstUser) {
        this.coSignerSetupIsFirstUser = coSignerSetupIsFirstUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAPIUser createAPIUser = (CreateAPIUser)o;
        return Objects.equals(this.role, createAPIUser.role) && Objects.equals(this.name, createAPIUser.name) && Objects.equals(this.csrPem, createAPIUser.csrPem) && Objects.equals(this.coSignerSetupType, createAPIUser.coSignerSetupType) && Objects.equals(this.coSignerSetupIsFirstUser, createAPIUser.coSignerSetupIsFirstUser);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.name, this.csrPem, this.coSignerSetupType, this.coSignerSetupIsFirstUser);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAPIUser {\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    csrPem: ").append(this.toIndentedString(this.csrPem)).append("\n");
        sb.append("    coSignerSetupType: ").append(this.toIndentedString(this.coSignerSetupType)).append("\n");
        sb.append("    coSignerSetupIsFirstUser: ").append(this.toIndentedString(this.coSignerSetupIsFirstUser)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getRole() != null) {
            joiner.add(String.format("%srole%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRole()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCsrPem() != null) {
            joiner.add(String.format("%scsrPem%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCsrPem()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCoSignerSetupType() != null) {
            joiner.add(String.format("%scoSignerSetupType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCoSignerSetupType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCoSignerSetupIsFirstUser() != null) {
            joiner.add(String.format("%scoSignerSetupIsFirstUser%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCoSignerSetupIsFirstUser()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

