/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"address", "legacyAddress", "enterpriseAddress", "tag", "bip44AddressIndex"})
public class CreateAddressResponse {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private String address;
    public static final String JSON_PROPERTY_LEGACY_ADDRESS = "legacyAddress";
    private String legacyAddress;
    public static final String JSON_PROPERTY_ENTERPRISE_ADDRESS = "enterpriseAddress";
    private String enterpriseAddress;
    public static final String JSON_PROPERTY_TAG = "tag";
    private String tag;
    public static final String JSON_PROPERTY_BIP44_ADDRESS_INDEX = "bip44AddressIndex";
    private Integer bip44AddressIndex;

    public CreateAddressResponse address(String address) {
        this.address = address;
        return this;
    }

    @Nullable
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(String address) {
        this.address = address;
    }

    public CreateAddressResponse legacyAddress(String legacyAddress) {
        this.legacyAddress = legacyAddress;
        return this;
    }

    @Nullable
    @JsonProperty(value="legacyAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegacyAddress() {
        return this.legacyAddress;
    }

    @JsonProperty(value="legacyAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegacyAddress(String legacyAddress) {
        this.legacyAddress = legacyAddress;
    }

    public CreateAddressResponse enterpriseAddress(String enterpriseAddress) {
        this.enterpriseAddress = enterpriseAddress;
        return this;
    }

    @Nullable
    @JsonProperty(value="enterpriseAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEnterpriseAddress() {
        return this.enterpriseAddress;
    }

    @JsonProperty(value="enterpriseAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnterpriseAddress(String enterpriseAddress) {
        this.enterpriseAddress = enterpriseAddress;
    }

    public CreateAddressResponse tag(String tag) {
        this.tag = tag;
        return this;
    }

    @Nullable
    @JsonProperty(value="tag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTag() {
        return this.tag;
    }

    @JsonProperty(value="tag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTag(String tag) {
        this.tag = tag;
    }

    public CreateAddressResponse bip44AddressIndex(Integer bip44AddressIndex) {
        this.bip44AddressIndex = bip44AddressIndex;
        return this;
    }

    @Nullable
    @JsonProperty(value="bip44AddressIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBip44AddressIndex() {
        return this.bip44AddressIndex;
    }

    @JsonProperty(value="bip44AddressIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBip44AddressIndex(Integer bip44AddressIndex) {
        this.bip44AddressIndex = bip44AddressIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAddressResponse createAddressResponse = (CreateAddressResponse)o;
        return Objects.equals(this.address, createAddressResponse.address) && Objects.equals(this.legacyAddress, createAddressResponse.legacyAddress) && Objects.equals(this.enterpriseAddress, createAddressResponse.enterpriseAddress) && Objects.equals(this.tag, createAddressResponse.tag) && Objects.equals(this.bip44AddressIndex, createAddressResponse.bip44AddressIndex);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.legacyAddress, this.enterpriseAddress, this.tag, this.bip44AddressIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAddressResponse {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    legacyAddress: ").append(this.toIndentedString(this.legacyAddress)).append("\n");
        sb.append("    enterpriseAddress: ").append(this.toIndentedString(this.enterpriseAddress)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    bip44AddressIndex: ").append(this.toIndentedString(this.bip44AddressIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAddress() != null) {
            joiner.add(String.format("%saddress%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAddress()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getLegacyAddress() != null) {
            joiner.add(String.format("%slegacyAddress%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLegacyAddress()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getEnterpriseAddress() != null) {
            joiner.add(String.format("%senterpriseAddress%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEnterpriseAddress()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTag() != null) {
            joiner.add(String.format("%stag%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTag()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getBip44AddressIndex() != null) {
            joiner.add(String.format("%sbip44AddressIndex%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBip44AddressIndex()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

