/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.TradingAccountType;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"asset", "amount", "sourceType", "destType"})
public class CreateInternalTransferRequest {
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private String amount;
    public static final String JSON_PROPERTY_SOURCE_TYPE = "sourceType";
    private TradingAccountType sourceType;
    public static final String JSON_PROPERTY_DEST_TYPE = "destType";
    private TradingAccountType destType;

    public CreateInternalTransferRequest asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nonnull
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public CreateInternalTransferRequest amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(String amount) {
        this.amount = amount;
    }

    public CreateInternalTransferRequest sourceType(TradingAccountType sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="sourceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TradingAccountType getSourceType() {
        return this.sourceType;
    }

    @JsonProperty(value="sourceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceType(TradingAccountType sourceType) {
        this.sourceType = sourceType;
    }

    public CreateInternalTransferRequest destType(TradingAccountType destType) {
        this.destType = destType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="destType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TradingAccountType getDestType() {
        return this.destType;
    }

    @JsonProperty(value="destType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDestType(TradingAccountType destType) {
        this.destType = destType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateInternalTransferRequest createInternalTransferRequest = (CreateInternalTransferRequest)o;
        return Objects.equals(this.asset, createInternalTransferRequest.asset) && Objects.equals(this.amount, createInternalTransferRequest.amount) && Objects.equals((Object)this.sourceType, (Object)createInternalTransferRequest.sourceType) && Objects.equals((Object)this.destType, (Object)createInternalTransferRequest.destType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.asset, this.amount, this.sourceType, this.destType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateInternalTransferRequest {\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    sourceType: ").append(this.toIndentedString((Object)this.sourceType)).append("\n");
        sb.append("    destType: ").append(this.toIndentedString((Object)this.destType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAsset() != null) {
            joiner.add(String.format("%sasset%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAsset()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAmount() != null) {
            joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSourceType() != null) {
            joiner.add(String.format("%ssourceType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getSourceType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDestType() != null) {
            joiner.add(String.format("%sdestType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getDestType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

