/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"ncwId", "ncwAccountId", "feeLevel", "uri", "chainIds"})
public class CreateNcwConnectionRequest {
    public static final String JSON_PROPERTY_NCW_ID = "ncwId";
    private String ncwId;
    public static final String JSON_PROPERTY_NCW_ACCOUNT_ID = "ncwAccountId";
    private BigDecimal ncwAccountId;
    public static final String JSON_PROPERTY_FEE_LEVEL = "feeLevel";
    private FeeLevelEnum feeLevel;
    public static final String JSON_PROPERTY_URI = "uri";
    private String uri;
    public static final String JSON_PROPERTY_CHAIN_IDS = "chainIds";
    private List<String> chainIds;

    public CreateNcwConnectionRequest ncwId(String ncwId) {
        this.ncwId = ncwId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="ncwId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNcwId() {
        return this.ncwId;
    }

    @JsonProperty(value="ncwId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNcwId(String ncwId) {
        this.ncwId = ncwId;
    }

    public CreateNcwConnectionRequest ncwAccountId(BigDecimal ncwAccountId) {
        this.ncwAccountId = ncwAccountId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="ncwAccountId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getNcwAccountId() {
        return this.ncwAccountId;
    }

    @JsonProperty(value="ncwAccountId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNcwAccountId(BigDecimal ncwAccountId) {
        this.ncwAccountId = ncwAccountId;
    }

    public CreateNcwConnectionRequest feeLevel(FeeLevelEnum feeLevel) {
        this.feeLevel = feeLevel;
        return this;
    }

    @Nonnull
    @JsonProperty(value="feeLevel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FeeLevelEnum getFeeLevel() {
        return this.feeLevel;
    }

    @JsonProperty(value="feeLevel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeeLevel(FeeLevelEnum feeLevel) {
        this.feeLevel = feeLevel;
    }

    public CreateNcwConnectionRequest uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Nonnull
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUri(String uri) {
        this.uri = uri;
    }

    public CreateNcwConnectionRequest chainIds(List<String> chainIds) {
        this.chainIds = chainIds;
        return this;
    }

    public CreateNcwConnectionRequest addChainIdsItem(String chainIdsItem) {
        if (this.chainIds == null) {
            this.chainIds = new ArrayList<String>();
        }
        this.chainIds.add(chainIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="chainIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getChainIds() {
        return this.chainIds;
    }

    @JsonProperty(value="chainIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChainIds(List<String> chainIds) {
        this.chainIds = chainIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateNcwConnectionRequest createNcwConnectionRequest = (CreateNcwConnectionRequest)o;
        return Objects.equals(this.ncwId, createNcwConnectionRequest.ncwId) && Objects.equals(this.ncwAccountId, createNcwConnectionRequest.ncwAccountId) && Objects.equals((Object)this.feeLevel, (Object)createNcwConnectionRequest.feeLevel) && Objects.equals(this.uri, createNcwConnectionRequest.uri) && Objects.equals(this.chainIds, createNcwConnectionRequest.chainIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ncwId, this.ncwAccountId, this.feeLevel, this.uri, this.chainIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateNcwConnectionRequest {\n");
        sb.append("    ncwId: ").append(this.toIndentedString(this.ncwId)).append("\n");
        sb.append("    ncwAccountId: ").append(this.toIndentedString(this.ncwAccountId)).append("\n");
        sb.append("    feeLevel: ").append(this.toIndentedString((Object)this.feeLevel)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    chainIds: ").append(this.toIndentedString(this.chainIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getNcwId() != null) {
            joiner.add(String.format("%sncwId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNcwId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getNcwAccountId() != null) {
            joiner.add(String.format("%sncwAccountId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNcwAccountId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFeeLevel() != null) {
            joiner.add(String.format("%sfeeLevel%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getFeeLevel()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUri() != null) {
            joiner.add(String.format("%suri%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUri()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getChainIds() != null) {
            for (int i = 0; i < this.getChainIds().size(); ++i) {
                joiner.add(String.format("%schainIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getChainIds().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }

    public static enum FeeLevelEnum {
        MEDIUM("MEDIUM"),
        HIGH("HIGH");

        private String value;

        private FeeLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FeeLevelEnum fromValue(String value) {
            for (FeeLevelEnum b : FeeLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

