/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.NetworkIdRoutingPolicyValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "routingPolicy"})
public class CreateNetworkIdRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ROUTING_POLICY = "routingPolicy";
    private Map<String, NetworkIdRoutingPolicyValue> routingPolicy = new HashMap<String, NetworkIdRoutingPolicyValue>();

    public CreateNetworkIdRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateNetworkIdRequest routingPolicy(Map<String, NetworkIdRoutingPolicyValue> routingPolicy) {
        this.routingPolicy = routingPolicy;
        return this;
    }

    public CreateNetworkIdRequest putRoutingPolicyItem(String key, NetworkIdRoutingPolicyValue routingPolicyItem) {
        if (this.routingPolicy == null) {
            this.routingPolicy = new HashMap<String, NetworkIdRoutingPolicyValue>();
        }
        this.routingPolicy.put(key, routingPolicyItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="routingPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, NetworkIdRoutingPolicyValue> getRoutingPolicy() {
        return this.routingPolicy;
    }

    @JsonProperty(value="routingPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoutingPolicy(Map<String, NetworkIdRoutingPolicyValue> routingPolicy) {
        this.routingPolicy = routingPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateNetworkIdRequest createNetworkIdRequest = (CreateNetworkIdRequest)o;
        return Objects.equals(this.name, createNetworkIdRequest.name) && Objects.equals(this.routingPolicy, createNetworkIdRequest.routingPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.routingPolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateNetworkIdRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    routingPolicy: ").append(this.toIndentedString(this.routingPolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRoutingPolicy() != null) {
            for (String _key : this.getRoutingPolicy().keySet()) {
                if (this.getRoutingPolicy().get(_key) == null) continue;
                joiner.add(this.getRoutingPolicy().get(_key).toUrlQueryString(String.format("%sroutingPolicy%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

