/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.PaymentAccount;
import com.fireblocks.sdk.model.PayoutInstruction;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"paymentAccount", "instructionSet"})
public class CreatePayoutRequest {
    public static final String JSON_PROPERTY_PAYMENT_ACCOUNT = "paymentAccount";
    private PaymentAccount paymentAccount;
    public static final String JSON_PROPERTY_INSTRUCTION_SET = "instructionSet";
    private List<PayoutInstruction> instructionSet = new ArrayList<PayoutInstruction>();

    public CreatePayoutRequest paymentAccount(PaymentAccount paymentAccount) {
        this.paymentAccount = paymentAccount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="paymentAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PaymentAccount getPaymentAccount() {
        return this.paymentAccount;
    }

    @JsonProperty(value="paymentAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPaymentAccount(PaymentAccount paymentAccount) {
        this.paymentAccount = paymentAccount;
    }

    public CreatePayoutRequest instructionSet(List<PayoutInstruction> instructionSet) {
        this.instructionSet = instructionSet;
        return this;
    }

    public CreatePayoutRequest addInstructionSetItem(PayoutInstruction instructionSetItem) {
        if (this.instructionSet == null) {
            this.instructionSet = new ArrayList<PayoutInstruction>();
        }
        this.instructionSet.add(instructionSetItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="instructionSet")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<PayoutInstruction> getInstructionSet() {
        return this.instructionSet;
    }

    @JsonProperty(value="instructionSet")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInstructionSet(List<PayoutInstruction> instructionSet) {
        this.instructionSet = instructionSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePayoutRequest createPayoutRequest = (CreatePayoutRequest)o;
        return Objects.equals(this.paymentAccount, createPayoutRequest.paymentAccount) && Objects.equals(this.instructionSet, createPayoutRequest.instructionSet);
    }

    public int hashCode() {
        return Objects.hash(this.paymentAccount, this.instructionSet);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePayoutRequest {\n");
        sb.append("    paymentAccount: ").append(this.toIndentedString(this.paymentAccount)).append("\n");
        sb.append("    instructionSet: ").append(this.toIndentedString(this.instructionSet)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getPaymentAccount() != null) {
            joiner.add(this.getPaymentAccount().toUrlQueryString((String)prefix + JSON_PROPERTY_PAYMENT_ACCOUNT + suffix));
        }
        if (this.getInstructionSet() != null) {
            for (int i = 0; i < this.getInstructionSet().size(); ++i) {
                if (this.getInstructionSet().get(i) == null) continue;
                joiner.add(this.getInstructionSet().get(i).toUrlQueryString(String.format("%sinstructionSet%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

