/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "hiddenOnUI", "customerRefId", "autoFuel", "vaultType", "autoAssign"})
public class CreateVaultAccountRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_HIDDEN_ON_U_I = "hiddenOnUI";
    private Boolean hiddenOnUI;
    public static final String JSON_PROPERTY_CUSTOMER_REF_ID = "customerRefId";
    private String customerRefId;
    public static final String JSON_PROPERTY_AUTO_FUEL = "autoFuel";
    private Boolean autoFuel;
    public static final String JSON_PROPERTY_VAULT_TYPE = "vaultType";
    private VaultTypeEnum vaultType = VaultTypeEnum.MPC;
    public static final String JSON_PROPERTY_AUTO_ASSIGN = "autoAssign";
    private Boolean autoAssign = false;

    public CreateVaultAccountRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateVaultAccountRequest hiddenOnUI(Boolean hiddenOnUI) {
        this.hiddenOnUI = hiddenOnUI;
        return this;
    }

    @Nullable
    @JsonProperty(value="hiddenOnUI")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHiddenOnUI() {
        return this.hiddenOnUI;
    }

    @JsonProperty(value="hiddenOnUI")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHiddenOnUI(Boolean hiddenOnUI) {
        this.hiddenOnUI = hiddenOnUI;
    }

    public CreateVaultAccountRequest customerRefId(String customerRefId) {
        this.customerRefId = customerRefId;
        return this;
    }

    @Nullable
    @JsonProperty(value="customerRefId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerRefId() {
        return this.customerRefId;
    }

    @JsonProperty(value="customerRefId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerRefId(String customerRefId) {
        this.customerRefId = customerRefId;
    }

    public CreateVaultAccountRequest autoFuel(Boolean autoFuel) {
        this.autoFuel = autoFuel;
        return this;
    }

    @Nullable
    @JsonProperty(value="autoFuel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutoFuel() {
        return this.autoFuel;
    }

    @JsonProperty(value="autoFuel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoFuel(Boolean autoFuel) {
        this.autoFuel = autoFuel;
    }

    public CreateVaultAccountRequest vaultType(VaultTypeEnum vaultType) {
        this.vaultType = vaultType;
        return this;
    }

    @Nullable
    @JsonProperty(value="vaultType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VaultTypeEnum getVaultType() {
        return this.vaultType;
    }

    @JsonProperty(value="vaultType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVaultType(VaultTypeEnum vaultType) {
        this.vaultType = vaultType;
    }

    public CreateVaultAccountRequest autoAssign(Boolean autoAssign) {
        this.autoAssign = autoAssign;
        return this;
    }

    @Nullable
    @JsonProperty(value="autoAssign")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutoAssign() {
        return this.autoAssign;
    }

    @JsonProperty(value="autoAssign")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAutoAssign(Boolean autoAssign) {
        this.autoAssign = autoAssign;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateVaultAccountRequest createVaultAccountRequest = (CreateVaultAccountRequest)o;
        return Objects.equals(this.name, createVaultAccountRequest.name) && Objects.equals(this.hiddenOnUI, createVaultAccountRequest.hiddenOnUI) && Objects.equals(this.customerRefId, createVaultAccountRequest.customerRefId) && Objects.equals(this.autoFuel, createVaultAccountRequest.autoFuel) && Objects.equals((Object)this.vaultType, (Object)createVaultAccountRequest.vaultType) && Objects.equals(this.autoAssign, createVaultAccountRequest.autoAssign);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.hiddenOnUI, this.customerRefId, this.autoFuel, this.vaultType, this.autoAssign});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateVaultAccountRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    hiddenOnUI: ").append(this.toIndentedString(this.hiddenOnUI)).append("\n");
        sb.append("    customerRefId: ").append(this.toIndentedString(this.customerRefId)).append("\n");
        sb.append("    autoFuel: ").append(this.toIndentedString(this.autoFuel)).append("\n");
        sb.append("    vaultType: ").append(this.toIndentedString((Object)this.vaultType)).append("\n");
        sb.append("    autoAssign: ").append(this.toIndentedString(this.autoAssign)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getHiddenOnUI() != null) {
            joiner.add(String.format("%shiddenOnUI%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getHiddenOnUI()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCustomerRefId() != null) {
            joiner.add(String.format("%scustomerRefId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCustomerRefId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAutoFuel() != null) {
            joiner.add(String.format("%sautoFuel%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAutoFuel()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getVaultType() != null) {
            joiner.add(String.format("%svaultType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getVaultType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAutoAssign() != null) {
            joiner.add(String.format("%sautoAssign%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAutoAssign()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum VaultTypeEnum {
        MPC("MPC"),
        KEY_LINK("KEY_LINK");

        private String value;

        private VaultTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VaultTypeEnum fromValue(String value) {
            for (VaultTypeEnum b : VaultTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

