/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"scheme", "dstType", "dstId"})
public class CustomRoutingDest {
    public static final String JSON_PROPERTY_SCHEME = "scheme";
    private SchemeEnum scheme;
    public static final String JSON_PROPERTY_DST_TYPE = "dstType";
    private DstTypeEnum dstType;
    public static final String JSON_PROPERTY_DST_ID = "dstId";
    private String dstId;

    public CustomRoutingDest scheme(SchemeEnum scheme) {
        this.scheme = scheme;
        return this;
    }

    @Nonnull
    @JsonProperty(value="scheme")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SchemeEnum getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setScheme(SchemeEnum scheme) {
        this.scheme = scheme;
    }

    public CustomRoutingDest dstType(DstTypeEnum dstType) {
        this.dstType = dstType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="dstType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DstTypeEnum getDstType() {
        return this.dstType;
    }

    @JsonProperty(value="dstType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDstType(DstTypeEnum dstType) {
        this.dstType = dstType;
    }

    public CustomRoutingDest dstId(String dstId) {
        this.dstId = dstId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="dstId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDstId() {
        return this.dstId;
    }

    @JsonProperty(value="dstId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDstId(String dstId) {
        this.dstId = dstId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomRoutingDest customRoutingDest = (CustomRoutingDest)o;
        return Objects.equals((Object)this.scheme, (Object)customRoutingDest.scheme) && Objects.equals((Object)this.dstType, (Object)customRoutingDest.dstType) && Objects.equals(this.dstId, customRoutingDest.dstId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.scheme, this.dstType, this.dstId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomRoutingDest {\n");
        sb.append("    scheme: ").append(this.toIndentedString((Object)this.scheme)).append("\n");
        sb.append("    dstType: ").append(this.toIndentedString((Object)this.dstType)).append("\n");
        sb.append("    dstId: ").append(this.toIndentedString(this.dstId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getScheme() != null) {
            joiner.add(String.format("%sscheme%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getScheme()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDstType() != null) {
            joiner.add(String.format("%sdstType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getDstType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDstId() != null) {
            joiner.add(String.format("%sdstId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDstId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum DstTypeEnum {
        FIAT_ACCOUNT("FIAT_ACCOUNT"),
        VAULT("VAULT"),
        EXCHANGE("EXCHANGE");

        private String value;

        private DstTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DstTypeEnum fromValue(String value) {
            for (DstTypeEnum b : DstTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SchemeEnum {
        CUSTOM("CUSTOM");

        private String value;

        private SchemeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SchemeEnum fromValue(String value) {
            for (SchemeEnum b : SchemeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

