/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.Account;
import com.fireblocks.sdk.model.DisbursementInstruction;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"paymentAccount", "instructionSet"})
public class DisbursementOperationConfigParams {
    public static final String JSON_PROPERTY_PAYMENT_ACCOUNT = "paymentAccount";
    private Account paymentAccount;
    public static final String JSON_PROPERTY_INSTRUCTION_SET = "instructionSet";
    private List<DisbursementInstruction> instructionSet = new ArrayList<DisbursementInstruction>();

    public DisbursementOperationConfigParams paymentAccount(Account paymentAccount) {
        this.paymentAccount = paymentAccount;
        return this;
    }

    @Nullable
    @JsonProperty(value="paymentAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Account getPaymentAccount() {
        return this.paymentAccount;
    }

    @JsonProperty(value="paymentAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentAccount(Account paymentAccount) {
        this.paymentAccount = paymentAccount;
    }

    public DisbursementOperationConfigParams instructionSet(List<DisbursementInstruction> instructionSet) {
        this.instructionSet = instructionSet;
        return this;
    }

    public DisbursementOperationConfigParams addInstructionSetItem(DisbursementInstruction instructionSetItem) {
        if (this.instructionSet == null) {
            this.instructionSet = new ArrayList<DisbursementInstruction>();
        }
        this.instructionSet.add(instructionSetItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="instructionSet")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<DisbursementInstruction> getInstructionSet() {
        return this.instructionSet;
    }

    @JsonProperty(value="instructionSet")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInstructionSet(List<DisbursementInstruction> instructionSet) {
        this.instructionSet = instructionSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisbursementOperationConfigParams disbursementOperationConfigParams = (DisbursementOperationConfigParams)o;
        return Objects.equals(this.paymentAccount, disbursementOperationConfigParams.paymentAccount) && Objects.equals(this.instructionSet, disbursementOperationConfigParams.instructionSet);
    }

    public int hashCode() {
        return Objects.hash(this.paymentAccount, this.instructionSet);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DisbursementOperationConfigParams {\n");
        sb.append("    paymentAccount: ").append(this.toIndentedString(this.paymentAccount)).append("\n");
        sb.append("    instructionSet: ").append(this.toIndentedString(this.instructionSet)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getPaymentAccount() != null) {
            joiner.add(this.getPaymentAccount().toUrlQueryString((String)prefix + JSON_PROPERTY_PAYMENT_ACCOUNT + suffix));
        }
        if (this.getInstructionSet() != null) {
            for (int i = 0; i < this.getInstructionSet().size(); ++i) {
                if (this.getInstructionSet().get(i) == null) continue;
                joiner.add(this.getInstructionSet().get(i).toUrlQueryString(String.format("%sinstructionSet%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

