/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.DisbursementOperationExecutionOutput;
import com.fireblocks.sdk.model.DisbursementOperationInput;
import com.fireblocks.sdk.model.OperationExecutionFailure;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"input", "output", "payoutId", "startedAt", "finishedAt", "failure"})
public class DisbursementOperationExecution {
    public static final String JSON_PROPERTY_INPUT = "input";
    private DisbursementOperationInput input;
    public static final String JSON_PROPERTY_OUTPUT = "output";
    private DisbursementOperationExecutionOutput output;
    public static final String JSON_PROPERTY_PAYOUT_ID = "payoutId";
    private String payoutId;
    public static final String JSON_PROPERTY_STARTED_AT = "startedAt";
    private BigDecimal startedAt;
    public static final String JSON_PROPERTY_FINISHED_AT = "finishedAt";
    private BigDecimal finishedAt;
    public static final String JSON_PROPERTY_FAILURE = "failure";
    private OperationExecutionFailure failure;

    public DisbursementOperationExecution input(DisbursementOperationInput input) {
        this.input = input;
        return this;
    }

    @Nonnull
    @JsonProperty(value="input")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DisbursementOperationInput getInput() {
        return this.input;
    }

    @JsonProperty(value="input")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInput(DisbursementOperationInput input) {
        this.input = input;
    }

    public DisbursementOperationExecution output(DisbursementOperationExecutionOutput output) {
        this.output = output;
        return this;
    }

    @Nullable
    @JsonProperty(value="output")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DisbursementOperationExecutionOutput getOutput() {
        return this.output;
    }

    @JsonProperty(value="output")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutput(DisbursementOperationExecutionOutput output) {
        this.output = output;
    }

    public DisbursementOperationExecution payoutId(String payoutId) {
        this.payoutId = payoutId;
        return this;
    }

    @Nullable
    @JsonProperty(value="payoutId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutId() {
        return this.payoutId;
    }

    @JsonProperty(value="payoutId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutId(String payoutId) {
        this.payoutId = payoutId;
    }

    public DisbursementOperationExecution startedAt(BigDecimal startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="startedAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getStartedAt() {
        return this.startedAt;
    }

    @JsonProperty(value="startedAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartedAt(BigDecimal startedAt) {
        this.startedAt = startedAt;
    }

    public DisbursementOperationExecution finishedAt(BigDecimal finishedAt) {
        this.finishedAt = finishedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="finishedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getFinishedAt() {
        return this.finishedAt;
    }

    @JsonProperty(value="finishedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFinishedAt(BigDecimal finishedAt) {
        this.finishedAt = finishedAt;
    }

    public DisbursementOperationExecution failure(OperationExecutionFailure failure) {
        this.failure = failure;
        return this;
    }

    @Nullable
    @JsonProperty(value="failure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OperationExecutionFailure getFailure() {
        return this.failure;
    }

    @JsonProperty(value="failure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailure(OperationExecutionFailure failure) {
        this.failure = failure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisbursementOperationExecution disbursementOperationExecution = (DisbursementOperationExecution)o;
        return Objects.equals(this.input, disbursementOperationExecution.input) && Objects.equals(this.output, disbursementOperationExecution.output) && Objects.equals(this.payoutId, disbursementOperationExecution.payoutId) && Objects.equals(this.startedAt, disbursementOperationExecution.startedAt) && Objects.equals(this.finishedAt, disbursementOperationExecution.finishedAt) && Objects.equals(this.failure, disbursementOperationExecution.failure);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.output, this.payoutId, this.startedAt, this.finishedAt, this.failure);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DisbursementOperationExecution {\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    output: ").append(this.toIndentedString(this.output)).append("\n");
        sb.append("    payoutId: ").append(this.toIndentedString(this.payoutId)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    finishedAt: ").append(this.toIndentedString(this.finishedAt)).append("\n");
        sb.append("    failure: ").append(this.toIndentedString(this.failure)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getInput() != null) {
            joiner.add(this.getInput().toUrlQueryString((String)prefix + JSON_PROPERTY_INPUT + suffix));
        }
        if (this.getOutput() != null) {
            joiner.add(this.getOutput().toUrlQueryString((String)prefix + JSON_PROPERTY_OUTPUT + suffix));
        }
        if (this.getPayoutId() != null) {
            joiner.add(String.format("%spayoutId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPayoutId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStartedAt() != null) {
            joiner.add(String.format("%sstartedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStartedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFinishedAt() != null) {
            joiner.add(String.format("%sfinishedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFinishedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFailure() != null) {
            joiner.add(this.getFailure().toUrlQueryString((String)prefix + JSON_PROPERTY_FAILURE + suffix));
        }
        return joiner.toString();
    }
}

