/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.Destination;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"payeeAccount", "assetId", "percentage"})
public class DisbursementPercentageInstruction {
    public static final String JSON_PROPERTY_PAYEE_ACCOUNT = "payeeAccount";
    private Destination payeeAccount;
    public static final String JSON_PROPERTY_ASSET_ID = "assetId";
    private String assetId;
    public static final String JSON_PROPERTY_PERCENTAGE = "percentage";
    private String percentage;

    public DisbursementPercentageInstruction payeeAccount(Destination payeeAccount) {
        this.payeeAccount = payeeAccount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="payeeAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Destination getPayeeAccount() {
        return this.payeeAccount;
    }

    @JsonProperty(value="payeeAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayeeAccount(Destination payeeAccount) {
        this.payeeAccount = payeeAccount;
    }

    public DisbursementPercentageInstruction assetId(String assetId) {
        this.assetId = assetId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="assetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAssetId() {
        return this.assetId;
    }

    @JsonProperty(value="assetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public DisbursementPercentageInstruction percentage(String percentage) {
        this.percentage = percentage;
        return this;
    }

    @Nonnull
    @JsonProperty(value="percentage")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPercentage() {
        return this.percentage;
    }

    @JsonProperty(value="percentage")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPercentage(String percentage) {
        this.percentage = percentage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisbursementPercentageInstruction disbursementPercentageInstruction = (DisbursementPercentageInstruction)o;
        return Objects.equals(this.payeeAccount, disbursementPercentageInstruction.payeeAccount) && Objects.equals(this.assetId, disbursementPercentageInstruction.assetId) && Objects.equals(this.percentage, disbursementPercentageInstruction.percentage);
    }

    public int hashCode() {
        return Objects.hash(this.payeeAccount, this.assetId, this.percentage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DisbursementPercentageInstruction {\n");
        sb.append("    payeeAccount: ").append(this.toIndentedString(this.payeeAccount)).append("\n");
        sb.append("    assetId: ").append(this.toIndentedString(this.assetId)).append("\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getPayeeAccount() != null) {
            joiner.add(this.getPayeeAccount().toUrlQueryString((String)prefix + JSON_PROPERTY_PAYEE_ACCOUNT + suffix));
        }
        if (this.getAssetId() != null) {
            joiner.add(String.format("%sassetId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAssetId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPercentage() != null) {
            joiner.add(String.format("%spercentage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPercentage()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

