/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.PolicyMetadata;
import com.fireblocks.sdk.model.PolicyRule;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"status", "rules", "draftId", "metadata"})
public class DraftResponse {
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_RULES = "rules";
    private List<PolicyRule> rules = new ArrayList<PolicyRule>();
    public static final String JSON_PROPERTY_DRAFT_ID = "draftId";
    private String draftId;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private PolicyMetadata metadata;

    public DraftResponse status(String status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(String status) {
        this.status = status;
    }

    public DraftResponse rules(List<PolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    public DraftResponse addRulesItem(PolicyRule rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<PolicyRule>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="rules")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<PolicyRule> getRules() {
        return this.rules;
    }

    @JsonProperty(value="rules")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRules(List<PolicyRule> rules) {
        this.rules = rules;
    }

    public DraftResponse draftId(String draftId) {
        this.draftId = draftId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="draftId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDraftId() {
        return this.draftId;
    }

    @JsonProperty(value="draftId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDraftId(String draftId) {
        this.draftId = draftId;
    }

    public DraftResponse metadata(PolicyMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PolicyMetadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMetadata(PolicyMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DraftResponse draftResponse = (DraftResponse)o;
        return Objects.equals(this.status, draftResponse.status) && Objects.equals(this.rules, draftResponse.rules) && Objects.equals(this.draftId, draftResponse.draftId) && Objects.equals(this.metadata, draftResponse.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.rules, this.draftId, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DraftResponse {\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("    draftId: ").append(this.toIndentedString(this.draftId)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getStatus() != null) {
            joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRules() != null) {
            for (int i = 0; i < this.getRules().size(); ++i) {
                if (this.getRules().get(i) == null) continue;
                joiner.add(this.getRules().get(i).toUrlQueryString(String.format("%srules%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getDraftId() != null) {
            joiner.add(String.format("%sdraftId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDraftId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getMetadata() != null) {
            joiner.add(this.getMetadata().toUrlQueryString((String)prefix + JSON_PROPERTY_METADATA + suffix));
        }
        return joiner.toString();
    }
}

