/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.ParameterWithValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"contractId", "constructorParams"})
public class EVMTokenCreateParamsDto {
    public static final String JSON_PROPERTY_CONTRACT_ID = "contractId";
    private String contractId;
    public static final String JSON_PROPERTY_CONSTRUCTOR_PARAMS = "constructorParams";
    private List<List<ParameterWithValue>> constructorParams;

    public EVMTokenCreateParamsDto contractId(String contractId) {
        this.contractId = contractId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="contractId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContractId() {
        return this.contractId;
    }

    @JsonProperty(value="contractId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public EVMTokenCreateParamsDto constructorParams(List<List<ParameterWithValue>> constructorParams) {
        this.constructorParams = constructorParams;
        return this;
    }

    public EVMTokenCreateParamsDto addConstructorParamsItem(List<ParameterWithValue> constructorParamsItem) {
        if (this.constructorParams == null) {
            this.constructorParams = new ArrayList<List<ParameterWithValue>>();
        }
        this.constructorParams.add(constructorParamsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="constructorParams")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<List<ParameterWithValue>> getConstructorParams() {
        return this.constructorParams;
    }

    @JsonProperty(value="constructorParams")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConstructorParams(List<List<ParameterWithValue>> constructorParams) {
        this.constructorParams = constructorParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EVMTokenCreateParamsDto evMTokenCreateParamsDto = (EVMTokenCreateParamsDto)o;
        return Objects.equals(this.contractId, evMTokenCreateParamsDto.contractId) && Objects.equals(this.constructorParams, evMTokenCreateParamsDto.constructorParams);
    }

    public int hashCode() {
        return Objects.hash(this.contractId, this.constructorParams);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EVMTokenCreateParamsDto {\n");
        sb.append("    contractId: ").append(this.toIndentedString(this.contractId)).append("\n");
        sb.append("    constructorParams: ").append(this.toIndentedString(this.constructorParams)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getContractId() != null) {
            joiner.add(String.format("%scontractId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getContractId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getConstructorParams() != null) {
            for (int i = 0; i < this.getConstructorParams().size(); ++i) {
                if (this.getConstructorParams().get(i) == null) continue;
                joiner.add(String.format("%sconstructorParams%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getConstructorParams().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }
}

