/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.ExchangeAsset;
import com.fireblocks.sdk.model.ExchangeTradingAccount;
import com.fireblocks.sdk.model.ExchangeType;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "type", "name", "status", "assets", "success", "tradingAccounts", "isSubaccount", "mainAccountId"})
public class ExchangeAccount {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ExchangeType type;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_ASSETS = "assets";
    private List<ExchangeAsset> assets;
    public static final String JSON_PROPERTY_SUCCESS = "success";
    private Boolean success;
    public static final String JSON_PROPERTY_TRADING_ACCOUNTS = "tradingAccounts";
    private List<ExchangeTradingAccount> tradingAccounts;
    public static final String JSON_PROPERTY_IS_SUBACCOUNT = "isSubaccount";
    private Boolean isSubaccount;
    public static final String JSON_PROPERTY_MAIN_ACCOUNT_ID = "mainAccountId";
    private String mainAccountId;

    public ExchangeAccount id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public ExchangeAccount type(ExchangeType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExchangeType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(ExchangeType type) {
        this.type = type;
    }

    public ExchangeAccount name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ExchangeAccount status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(String status) {
        this.status = status;
    }

    public ExchangeAccount assets(List<ExchangeAsset> assets) {
        this.assets = assets;
        return this;
    }

    public ExchangeAccount addAssetsItem(ExchangeAsset assetsItem) {
        if (this.assets == null) {
            this.assets = new ArrayList<ExchangeAsset>();
        }
        this.assets.add(assetsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="assets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ExchangeAsset> getAssets() {
        return this.assets;
    }

    @JsonProperty(value="assets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssets(List<ExchangeAsset> assets) {
        this.assets = assets;
    }

    public ExchangeAccount success(Boolean success) {
        this.success = success;
        return this;
    }

    @Nullable
    @JsonProperty(value="success")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuccess() {
        return this.success;
    }

    @JsonProperty(value="success")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public ExchangeAccount tradingAccounts(List<ExchangeTradingAccount> tradingAccounts) {
        this.tradingAccounts = tradingAccounts;
        return this;
    }

    public ExchangeAccount addTradingAccountsItem(ExchangeTradingAccount tradingAccountsItem) {
        if (this.tradingAccounts == null) {
            this.tradingAccounts = new ArrayList<ExchangeTradingAccount>();
        }
        this.tradingAccounts.add(tradingAccountsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tradingAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ExchangeTradingAccount> getTradingAccounts() {
        return this.tradingAccounts;
    }

    @JsonProperty(value="tradingAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTradingAccounts(List<ExchangeTradingAccount> tradingAccounts) {
        this.tradingAccounts = tradingAccounts;
    }

    public ExchangeAccount isSubaccount(Boolean isSubaccount) {
        this.isSubaccount = isSubaccount;
        return this;
    }

    @Nullable
    @JsonProperty(value="isSubaccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsSubaccount() {
        return this.isSubaccount;
    }

    @JsonProperty(value="isSubaccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsSubaccount(Boolean isSubaccount) {
        this.isSubaccount = isSubaccount;
    }

    public ExchangeAccount mainAccountId(String mainAccountId) {
        this.mainAccountId = mainAccountId;
        return this;
    }

    @Nullable
    @JsonProperty(value="mainAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMainAccountId() {
        return this.mainAccountId;
    }

    @JsonProperty(value="mainAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMainAccountId(String mainAccountId) {
        this.mainAccountId = mainAccountId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExchangeAccount exchangeAccount = (ExchangeAccount)o;
        return Objects.equals(this.id, exchangeAccount.id) && Objects.equals((Object)this.type, (Object)exchangeAccount.type) && Objects.equals(this.name, exchangeAccount.name) && Objects.equals(this.status, exchangeAccount.status) && Objects.equals(this.assets, exchangeAccount.assets) && Objects.equals(this.success, exchangeAccount.success) && Objects.equals(this.tradingAccounts, exchangeAccount.tradingAccounts) && Objects.equals(this.isSubaccount, exchangeAccount.isSubaccount) && Objects.equals(this.mainAccountId, exchangeAccount.mainAccountId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.name, this.status, this.assets, this.success, this.tradingAccounts, this.isSubaccount, this.mainAccountId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExchangeAccount {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("    tradingAccounts: ").append(this.toIndentedString(this.tradingAccounts)).append("\n");
        sb.append("    isSubaccount: ").append(this.toIndentedString(this.isSubaccount)).append("\n");
        sb.append("    mainAccountId: ").append(this.toIndentedString(this.mainAccountId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatus() != null) {
            joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAssets() != null) {
            for (i = 0; i < this.getAssets().size(); ++i) {
                if (this.getAssets().get(i) == null) continue;
                joiner.add(this.getAssets().get(i).toUrlQueryString(String.format("%sassets%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getSuccess() != null) {
            joiner.add(String.format("%ssuccess%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSuccess()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTradingAccounts() != null) {
            for (i = 0; i < this.getTradingAccounts().size(); ++i) {
                if (this.getTradingAccounts().get(i) == null) continue;
                joiner.add(this.getTradingAccounts().get(i).toUrlQueryString(String.format("%stradingAccounts%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getIsSubaccount() != null) {
            joiner.add(String.format("%sisSubaccount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIsSubaccount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getMainAccountId() != null) {
            joiner.add(String.format("%smainAccountId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getMainAccountId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

