/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ExchangeType {
    BINANCE("BINANCE"),
    BINANCEUS("BINANCEUS"),
    BITFINEX("BITFINEX"),
    BITHUMB("BITHUMB"),
    BITMEX("BITMEX"),
    BITSO("BITSO"),
    BITSTAMP("BITSTAMP"),
    BITTREX("BITTREX"),
    CIRCLE("CIRCLE"),
    COINBASEPRO("COINBASEPRO"),
    COINMETRO("COINMETRO"),
    COINSPRO("COINSPRO"),
    CRYPTOCOM("CRYPTOCOM"),
    DERIBIT("DERIBIT"),
    FTX("FTX"),
    FIXUS("FIXUS"),
    GEMINI("GEMINI"),
    HITBTC("HITBTC"),
    HUOBI("HUOBI"),
    KORBIT("KORBIT"),
    KRAKEN("KRAKEN"),
    LIQUID("LIQUID"),
    POLONIEX("POLONIEX"),
    OKCOIN("OKCOIN"),
    OKEX("OKEX"),
    SEEDCX("SEEDCX");

    private String value;

    private ExchangeType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static ExchangeType fromValue(String value) {
        for (ExchangeType b : ExchangeType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

