/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fireblocks.sdk.JSON;
import com.fireblocks.sdk.model.AbstractOpenApiSchema;
import com.fireblocks.sdk.model.StakeRequestDto;
import com.fireblocks.sdk.model.UnstakeRequestDto;
import com.fireblocks.sdk.model.WithdrawRequestDto;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonDeserialize(using=ExecuteActionRequestDeserializer.class)
@JsonSerialize(using=ExecuteActionRequestSerializer.class)
public class ExecuteActionRequest
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(ExecuteActionRequest.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    public ExecuteActionRequest() {
        super("oneOf", Boolean.FALSE);
    }

    public ExecuteActionRequest(StakeRequestDto o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public ExecuteActionRequest(UnstakeRequestDto o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public ExecuteActionRequest(WithdrawRequestDto o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(StakeRequestDto.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(UnstakeRequestDto.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(WithdrawRequestDto.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be StakeRequestDto, UnstakeRequestDto, WithdrawRequestDto");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public StakeRequestDto getStakeRequestDto() throws ClassCastException {
        return (StakeRequestDto)super.getActualInstance();
    }

    public UnstakeRequestDto getUnstakeRequestDto() throws ClassCastException {
        return (UnstakeRequestDto)super.getActualInstance();
    }

    public WithdrawRequestDto getWithdrawRequestDto() throws ClassCastException {
        return (WithdrawRequestDto)super.getActualInstance();
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getActualInstance() instanceof StakeRequestDto) {
            if (this.getActualInstance() != null) {
                joiner.add(((StakeRequestDto)this.getActualInstance()).toUrlQueryString((String)prefix + "one_of_0" + suffix));
            }
            return joiner.toString();
        }
        if (this.getActualInstance() instanceof UnstakeRequestDto) {
            if (this.getActualInstance() != null) {
                joiner.add(((UnstakeRequestDto)this.getActualInstance()).toUrlQueryString((String)prefix + "one_of_1" + suffix));
            }
            return joiner.toString();
        }
        if (this.getActualInstance() instanceof WithdrawRequestDto) {
            if (this.getActualInstance() != null) {
                joiner.add(((WithdrawRequestDto)this.getActualInstance()).toUrlQueryString((String)prefix + "one_of_2" + suffix));
            }
            return joiner.toString();
        }
        return null;
    }

    static {
        schemas.put("StakeRequestDto", StakeRequestDto.class);
        schemas.put("UnstakeRequestDto", UnstakeRequestDto.class);
        schemas.put("WithdrawRequestDto", WithdrawRequestDto.class);
        JSON.registerDescendants(ExecuteActionRequest.class, Collections.unmodifiableMap(schemas));
    }

    public static class ExecuteActionRequestDeserializer
    extends StdDeserializer<ExecuteActionRequest> {
        public ExecuteActionRequestDeserializer() {
            this(ExecuteActionRequest.class);
        }

        public ExecuteActionRequestDeserializer(Class<?> vc) {
            super(vc);
        }

        public ExecuteActionRequest deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            Object deserialized = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            try {
                boolean attemptParsing = true;
                if ((StakeRequestDto.class.equals(Integer.class) || StakeRequestDto.class.equals(Long.class) || StakeRequestDto.class.equals(Float.class) || StakeRequestDto.class.equals(Double.class) || StakeRequestDto.class.equals(Boolean.class) || StakeRequestDto.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (StakeRequestDto.class.equals(Integer.class) || StakeRequestDto.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= (StakeRequestDto.class.equals(Float.class) || StakeRequestDto.class.equals(Double.class)) && token == JsonToken.VALUE_NUMBER_FLOAT;
                    attemptParsing |= StakeRequestDto.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= StakeRequestDto.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    deserialized = tree.traverse(jp.getCodec()).readValueAs(StakeRequestDto.class);
                    ++match;
                    log.log(Level.FINER, "Input data matches schema 'StakeRequestDto'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'StakeRequestDto'", e);
            }
            try {
                boolean attemptParsing = true;
                if ((UnstakeRequestDto.class.equals(Integer.class) || UnstakeRequestDto.class.equals(Long.class) || UnstakeRequestDto.class.equals(Float.class) || UnstakeRequestDto.class.equals(Double.class) || UnstakeRequestDto.class.equals(Boolean.class) || UnstakeRequestDto.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (UnstakeRequestDto.class.equals(Integer.class) || UnstakeRequestDto.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= (UnstakeRequestDto.class.equals(Float.class) || UnstakeRequestDto.class.equals(Double.class)) && token == JsonToken.VALUE_NUMBER_FLOAT;
                    attemptParsing |= UnstakeRequestDto.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= UnstakeRequestDto.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    deserialized = tree.traverse(jp.getCodec()).readValueAs(UnstakeRequestDto.class);
                    ++match;
                    log.log(Level.FINER, "Input data matches schema 'UnstakeRequestDto'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'UnstakeRequestDto'", e);
            }
            try {
                boolean attemptParsing = true;
                if ((WithdrawRequestDto.class.equals(Integer.class) || WithdrawRequestDto.class.equals(Long.class) || WithdrawRequestDto.class.equals(Float.class) || WithdrawRequestDto.class.equals(Double.class) || WithdrawRequestDto.class.equals(Boolean.class) || WithdrawRequestDto.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (WithdrawRequestDto.class.equals(Integer.class) || WithdrawRequestDto.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= (WithdrawRequestDto.class.equals(Float.class) || WithdrawRequestDto.class.equals(Double.class)) && token == JsonToken.VALUE_NUMBER_FLOAT;
                    attemptParsing |= WithdrawRequestDto.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= WithdrawRequestDto.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    deserialized = tree.traverse(jp.getCodec()).readValueAs(WithdrawRequestDto.class);
                    ++match;
                    log.log(Level.FINER, "Input data matches schema 'WithdrawRequestDto'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'WithdrawRequestDto'", e);
            }
            if (match == 1) {
                ExecuteActionRequest ret = new ExecuteActionRequest();
                ret.setActualInstance(deserialized);
                return ret;
            }
            throw new IOException(String.format("Failed deserialization for ExecuteActionRequest: %d classes match result, expected 1", match));
        }

        public ExecuteActionRequest getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "ExecuteActionRequest cannot be null");
        }
    }

    public static class ExecuteActionRequestSerializer
    extends StdSerializer<ExecuteActionRequest> {
        public ExecuteActionRequestSerializer(Class<ExecuteActionRequest> t) {
            super(t);
        }

        public ExecuteActionRequestSerializer() {
            this(null);
        }

        public void serialize(ExecuteActionRequest value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }
}

