/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.DisbursementOperationExecution;
import com.fireblocks.sdk.model.DisbursementOperationPreview;
import com.fireblocks.sdk.model.DisbursementOperationType;
import com.fireblocks.sdk.model.DisbursementValidationFailure;
import com.fireblocks.sdk.model.ExecutionOperationStatus;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"operationId", "status", "validationFailure", "operationType", "preview", "execution"})
public class ExecutionDisbursementOperation {
    public static final String JSON_PROPERTY_OPERATION_ID = "operationId";
    private String operationId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private ExecutionOperationStatus status;
    public static final String JSON_PROPERTY_VALIDATION_FAILURE = "validationFailure";
    private DisbursementValidationFailure validationFailure;
    public static final String JSON_PROPERTY_OPERATION_TYPE = "operationType";
    private DisbursementOperationType operationType;
    public static final String JSON_PROPERTY_PREVIEW = "preview";
    private DisbursementOperationPreview preview;
    public static final String JSON_PROPERTY_EXECUTION = "execution";
    private DisbursementOperationExecution execution;

    public ExecutionDisbursementOperation operationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="operationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOperationId() {
        return this.operationId;
    }

    @JsonProperty(value="operationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public ExecutionDisbursementOperation status(ExecutionOperationStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ExecutionOperationStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(ExecutionOperationStatus status) {
        this.status = status;
    }

    public ExecutionDisbursementOperation validationFailure(DisbursementValidationFailure validationFailure) {
        this.validationFailure = validationFailure;
        return this;
    }

    @Nullable
    @JsonProperty(value="validationFailure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DisbursementValidationFailure getValidationFailure() {
        return this.validationFailure;
    }

    @JsonProperty(value="validationFailure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValidationFailure(DisbursementValidationFailure validationFailure) {
        this.validationFailure = validationFailure;
    }

    public ExecutionDisbursementOperation operationType(DisbursementOperationType operationType) {
        this.operationType = operationType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="operationType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DisbursementOperationType getOperationType() {
        return this.operationType;
    }

    @JsonProperty(value="operationType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOperationType(DisbursementOperationType operationType) {
        this.operationType = operationType;
    }

    public ExecutionDisbursementOperation preview(DisbursementOperationPreview preview) {
        this.preview = preview;
        return this;
    }

    @Nullable
    @JsonProperty(value="preview")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DisbursementOperationPreview getPreview() {
        return this.preview;
    }

    @JsonProperty(value="preview")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreview(DisbursementOperationPreview preview) {
        this.preview = preview;
    }

    public ExecutionDisbursementOperation execution(DisbursementOperationExecution execution) {
        this.execution = execution;
        return this;
    }

    @Nullable
    @JsonProperty(value="execution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DisbursementOperationExecution getExecution() {
        return this.execution;
    }

    @JsonProperty(value="execution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExecution(DisbursementOperationExecution execution) {
        this.execution = execution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionDisbursementOperation executionDisbursementOperation = (ExecutionDisbursementOperation)o;
        return Objects.equals(this.operationId, executionDisbursementOperation.operationId) && Objects.equals((Object)this.status, (Object)executionDisbursementOperation.status) && Objects.equals(this.validationFailure, executionDisbursementOperation.validationFailure) && Objects.equals((Object)this.operationType, (Object)executionDisbursementOperation.operationType) && Objects.equals(this.preview, executionDisbursementOperation.preview) && Objects.equals(this.execution, executionDisbursementOperation.execution);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operationId, this.status, this.validationFailure, this.operationType, this.preview, this.execution});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExecutionDisbursementOperation {\n");
        sb.append("    operationId: ").append(this.toIndentedString(this.operationId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    validationFailure: ").append(this.toIndentedString(this.validationFailure)).append("\n");
        sb.append("    operationType: ").append(this.toIndentedString((Object)this.operationType)).append("\n");
        sb.append("    preview: ").append(this.toIndentedString(this.preview)).append("\n");
        sb.append("    execution: ").append(this.toIndentedString(this.execution)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getOperationId() != null) {
            joiner.add(String.format("%soperationId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getOperationId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatus() != null) {
            joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getValidationFailure() != null) {
            joiner.add(this.getValidationFailure().toUrlQueryString((String)prefix + JSON_PROPERTY_VALIDATION_FAILURE + suffix));
        }
        if (this.getOperationType() != null) {
            joiner.add(String.format("%soperationType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getOperationType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPreview() != null) {
            joiner.add(this.getPreview().toUrlQueryString((String)prefix + JSON_PROPERTY_PREVIEW + suffix));
        }
        if (this.getExecution() != null) {
            joiner.add(this.getExecution().toUrlQueryString((String)prefix + JSON_PROPERTY_EXECUTION + suffix));
        }
        return joiner.toString();
    }
}

