/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"networkFee", "serviceFee", "gasPrice"})
public class FeeInfo {
    public static final String JSON_PROPERTY_NETWORK_FEE = "networkFee";
    private String networkFee;
    public static final String JSON_PROPERTY_SERVICE_FEE = "serviceFee";
    private String serviceFee;
    public static final String JSON_PROPERTY_GAS_PRICE = "gasPrice";
    private String gasPrice;

    public FeeInfo networkFee(String networkFee) {
        this.networkFee = networkFee;
        return this;
    }

    @Nullable
    @JsonProperty(value="networkFee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetworkFee() {
        return this.networkFee;
    }

    @JsonProperty(value="networkFee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkFee(String networkFee) {
        this.networkFee = networkFee;
    }

    public FeeInfo serviceFee(String serviceFee) {
        this.serviceFee = serviceFee;
        return this;
    }

    @Nullable
    @JsonProperty(value="serviceFee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getServiceFee() {
        return this.serviceFee;
    }

    @JsonProperty(value="serviceFee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServiceFee(String serviceFee) {
        this.serviceFee = serviceFee;
    }

    public FeeInfo gasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
        return this;
    }

    @Nullable
    @JsonProperty(value="gasPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGasPrice() {
        return this.gasPrice;
    }

    @JsonProperty(value="gasPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeeInfo feeInfo = (FeeInfo)o;
        return Objects.equals(this.networkFee, feeInfo.networkFee) && Objects.equals(this.serviceFee, feeInfo.serviceFee) && Objects.equals(this.gasPrice, feeInfo.gasPrice);
    }

    public int hashCode() {
        return Objects.hash(this.networkFee, this.serviceFee, this.gasPrice);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeeInfo {\n");
        sb.append("    networkFee: ").append(this.toIndentedString(this.networkFee)).append("\n");
        sb.append("    serviceFee: ").append(this.toIndentedString(this.serviceFee)).append("\n");
        sb.append("    gasPrice: ").append(this.toIndentedString(this.gasPrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getNetworkFee() != null) {
            joiner.add(String.format("%snetworkFee%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNetworkFee()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getServiceFee() != null) {
            joiner.add(String.format("%sserviceFee%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getServiceFee()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getGasPrice() != null) {
            joiner.add(String.format("%sgasPrice%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getGasPrice()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

