/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"details", "params", "returns"})
public class FunctionDoc {
    public static final String JSON_PROPERTY_DETAILS = "details";
    private String details;
    public static final String JSON_PROPERTY_PARAMS = "params";
    private Map<String, String> params = new HashMap<String, String>();
    public static final String JSON_PROPERTY_RETURNS = "returns";
    private Map<String, String> returns = new HashMap<String, String>();

    public FunctionDoc details(String details) {
        this.details = details;
        return this;
    }

    @Nullable
    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDetails() {
        return this.details;
    }

    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDetails(String details) {
        this.details = details;
    }

    public FunctionDoc params(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public FunctionDoc putParamsItem(String key, String paramsItem) {
        if (this.params == null) {
            this.params = new HashMap<String, String>();
        }
        this.params.put(key, paramsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="params")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getParams() {
        return this.params;
    }

    @JsonProperty(value="params")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public FunctionDoc returns(Map<String, String> returns) {
        this.returns = returns;
        return this;
    }

    public FunctionDoc putReturnsItem(String key, String returnsItem) {
        if (this.returns == null) {
            this.returns = new HashMap<String, String>();
        }
        this.returns.put(key, returnsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="returns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getReturns() {
        return this.returns;
    }

    @JsonProperty(value="returns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReturns(Map<String, String> returns) {
        this.returns = returns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionDoc functionDoc = (FunctionDoc)o;
        return Objects.equals(this.details, functionDoc.details) && Objects.equals(this.params, functionDoc.params) && Objects.equals(this.returns, functionDoc.returns);
    }

    public int hashCode() {
        return Objects.hash(this.details, this.params, this.returns);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FunctionDoc {\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    params: ").append(this.toIndentedString(this.params)).append("\n");
        sb.append("    returns: ").append(this.toIndentedString(this.returns)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getDetails() != null) {
            joiner.add(String.format("%sdetails%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDetails()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getParams() != null) {
            for (String _key : this.getParams().keySet()) {
                joiner.add(String.format("%sparams%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getParams().get(_key), URLEncoder.encode(String.valueOf(this.getParams().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getReturns() != null) {
            for (String _key : this.getReturns().keySet()) {
                joiner.add(String.format("%sreturns%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getReturns().get(_key), URLEncoder.encode(String.valueOf(this.getReturns().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }
}

