/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.AuditLogData;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"data", "cursor", "total"})
public class GetAuditLogsResponse {
    public static final String JSON_PROPERTY_DATA = "data";
    private List<AuditLogData> data;
    public static final String JSON_PROPERTY_CURSOR = "cursor";
    private String cursor;
    public static final String JSON_PROPERTY_TOTAL = "total";
    private BigDecimal total;

    public GetAuditLogsResponse data(List<AuditLogData> data) {
        this.data = data;
        return this;
    }

    public GetAuditLogsResponse addDataItem(AuditLogData dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<AuditLogData>();
        }
        this.data.add(dataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AuditLogData> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setData(List<AuditLogData> data) {
        this.data = data;
    }

    public GetAuditLogsResponse cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @Nullable
    @JsonProperty(value="cursor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="cursor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public GetAuditLogsResponse total(BigDecimal total) {
        this.total = total;
        return this;
    }

    @Nullable
    @JsonProperty(value="total")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getTotal() {
        return this.total;
    }

    @JsonProperty(value="total")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAuditLogsResponse getAuditLogsResponse = (GetAuditLogsResponse)o;
        return Objects.equals(this.data, getAuditLogsResponse.data) && Objects.equals(this.cursor, getAuditLogsResponse.cursor) && Objects.equals(this.total, getAuditLogsResponse.total);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.cursor, this.total);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetAuditLogsResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getData() != null) {
            for (int i = 0; i < this.getData().size(); ++i) {
                if (this.getData().get(i) == null) continue;
                joiner.add(this.getData().get(i).toUrlQueryString(String.format("%sdata%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getCursor() != null) {
            joiner.add(String.format("%scursor%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCursor()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTotal() != null) {
            joiner.add(String.format("%stotal%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTotal()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

