/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"amount", "assetId"})
public class InstructionAmount {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private String amount;
    public static final String JSON_PROPERTY_ASSET_ID = "assetId";
    private String assetId;

    public InstructionAmount amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(String amount) {
        this.amount = amount;
    }

    public InstructionAmount assetId(String assetId) {
        this.assetId = assetId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="assetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAssetId() {
        return this.assetId;
    }

    @JsonProperty(value="assetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstructionAmount instructionAmount = (InstructionAmount)o;
        return Objects.equals(this.amount, instructionAmount.amount) && Objects.equals(this.assetId, instructionAmount.assetId);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.assetId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstructionAmount {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    assetId: ").append(this.toIndentedString(this.assetId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAmount() != null) {
            joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAssetId() != null) {
            joiner.add(String.format("%sassetId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAssetId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

