/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"url", "contentType"})
public class MediaEntityResponse {
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_CONTENT_TYPE = "contentType";
    private ContentTypeEnum contentType;

    public MediaEntityResponse url(String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(String url) {
        this.url = url;
    }

    public MediaEntityResponse contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaEntityResponse mediaEntityResponse = (MediaEntityResponse)o;
        return Objects.equals(this.url, mediaEntityResponse.url) && Objects.equals((Object)this.contentType, (Object)mediaEntityResponse.contentType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.contentType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaEntityResponse {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getUrl() != null) {
            joiner.add(String.format("%surl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUrl()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getContentType() != null) {
            joiner.add(String.format("%scontentType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getContentType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum ContentTypeEnum {
        IMAGE("IMAGE"),
        VIDEO("VIDEO"),
        ANIMATION("ANIMATION"),
        THREE_D("THREE_D"),
        TEXT("TEXT"),
        GIF("GIF"),
        UNKNOWN_TYPE("UNKNOWN_TYPE"),
        SVG("SVG"),
        AUDIO("AUDIO");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ContentTypeEnum fromValue(String value) {
            for (ContentTypeEnum b : ContentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

