/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.NetworkConnectionRoutingPolicyValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"localNetworkId", "remoteNetworkId", "routingPolicy"})
public class NetworkConnection {
    public static final String JSON_PROPERTY_LOCAL_NETWORK_ID = "localNetworkId";
    private String localNetworkId;
    public static final String JSON_PROPERTY_REMOTE_NETWORK_ID = "remoteNetworkId";
    private String remoteNetworkId;
    public static final String JSON_PROPERTY_ROUTING_POLICY = "routingPolicy";
    private Map<String, NetworkConnectionRoutingPolicyValue> routingPolicy = new HashMap<String, NetworkConnectionRoutingPolicyValue>();

    public NetworkConnection localNetworkId(String localNetworkId) {
        this.localNetworkId = localNetworkId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="localNetworkId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLocalNetworkId() {
        return this.localNetworkId;
    }

    @JsonProperty(value="localNetworkId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocalNetworkId(String localNetworkId) {
        this.localNetworkId = localNetworkId;
    }

    public NetworkConnection remoteNetworkId(String remoteNetworkId) {
        this.remoteNetworkId = remoteNetworkId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="remoteNetworkId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRemoteNetworkId() {
        return this.remoteNetworkId;
    }

    @JsonProperty(value="remoteNetworkId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRemoteNetworkId(String remoteNetworkId) {
        this.remoteNetworkId = remoteNetworkId;
    }

    public NetworkConnection routingPolicy(Map<String, NetworkConnectionRoutingPolicyValue> routingPolicy) {
        this.routingPolicy = routingPolicy;
        return this;
    }

    public NetworkConnection putRoutingPolicyItem(String key, NetworkConnectionRoutingPolicyValue routingPolicyItem) {
        if (this.routingPolicy == null) {
            this.routingPolicy = new HashMap<String, NetworkConnectionRoutingPolicyValue>();
        }
        this.routingPolicy.put(key, routingPolicyItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="routingPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, NetworkConnectionRoutingPolicyValue> getRoutingPolicy() {
        return this.routingPolicy;
    }

    @JsonProperty(value="routingPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoutingPolicy(Map<String, NetworkConnectionRoutingPolicyValue> routingPolicy) {
        this.routingPolicy = routingPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkConnection networkConnection = (NetworkConnection)o;
        return Objects.equals(this.localNetworkId, networkConnection.localNetworkId) && Objects.equals(this.remoteNetworkId, networkConnection.remoteNetworkId) && Objects.equals(this.routingPolicy, networkConnection.routingPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.localNetworkId, this.remoteNetworkId, this.routingPolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetworkConnection {\n");
        sb.append("    localNetworkId: ").append(this.toIndentedString(this.localNetworkId)).append("\n");
        sb.append("    remoteNetworkId: ").append(this.toIndentedString(this.remoteNetworkId)).append("\n");
        sb.append("    routingPolicy: ").append(this.toIndentedString(this.routingPolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getLocalNetworkId() != null) {
            joiner.add(String.format("%slocalNetworkId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLocalNetworkId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRemoteNetworkId() != null) {
            joiner.add(String.format("%sremoteNetworkId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRemoteNetworkId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRoutingPolicy() != null) {
            for (String _key : this.getRoutingPolicy().keySet()) {
                if (this.getRoutingPolicy().get(_key) == null) continue;
                joiner.add(this.getRoutingPolicy().get(_key).toUrlQueryString(String.format("%sroutingPolicy%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

