/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.NetworkChannel;
import com.fireblocks.sdk.model.NetworkConnectionRoutingPolicyValue;
import com.fireblocks.sdk.model.NetworkConnectionStatus;
import com.fireblocks.sdk.model.NetworkId;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "localChannel", "remoteChannel", "status", "localNetworkId", "remoteNetworkId", "routingPolicy"})
public class NetworkConnectionResponse {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LOCAL_CHANNEL = "localChannel";
    private NetworkChannel localChannel;
    public static final String JSON_PROPERTY_REMOTE_CHANNEL = "remoteChannel";
    private NetworkChannel remoteChannel;
    public static final String JSON_PROPERTY_STATUS = "status";
    private NetworkConnectionStatus status;
    public static final String JSON_PROPERTY_LOCAL_NETWORK_ID = "localNetworkId";
    private NetworkId localNetworkId;
    public static final String JSON_PROPERTY_REMOTE_NETWORK_ID = "remoteNetworkId";
    private NetworkId remoteNetworkId;
    public static final String JSON_PROPERTY_ROUTING_POLICY = "routingPolicy";
    private Map<String, NetworkConnectionRoutingPolicyValue> routingPolicy = new HashMap<String, NetworkConnectionRoutingPolicyValue>();

    public NetworkConnectionResponse id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public NetworkConnectionResponse localChannel(NetworkChannel localChannel) {
        this.localChannel = localChannel;
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="localChannel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NetworkChannel getLocalChannel() {
        return this.localChannel;
    }

    @JsonProperty(value="localChannel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocalChannel(NetworkChannel localChannel) {
        this.localChannel = localChannel;
    }

    public NetworkConnectionResponse remoteChannel(NetworkChannel remoteChannel) {
        this.remoteChannel = remoteChannel;
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="remoteChannel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NetworkChannel getRemoteChannel() {
        return this.remoteChannel;
    }

    @JsonProperty(value="remoteChannel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemoteChannel(NetworkChannel remoteChannel) {
        this.remoteChannel = remoteChannel;
    }

    public NetworkConnectionResponse status(NetworkConnectionStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NetworkConnectionStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(NetworkConnectionStatus status) {
        this.status = status;
    }

    public NetworkConnectionResponse localNetworkId(NetworkId localNetworkId) {
        this.localNetworkId = localNetworkId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="localNetworkId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NetworkId getLocalNetworkId() {
        return this.localNetworkId;
    }

    @JsonProperty(value="localNetworkId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocalNetworkId(NetworkId localNetworkId) {
        this.localNetworkId = localNetworkId;
    }

    public NetworkConnectionResponse remoteNetworkId(NetworkId remoteNetworkId) {
        this.remoteNetworkId = remoteNetworkId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="remoteNetworkId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NetworkId getRemoteNetworkId() {
        return this.remoteNetworkId;
    }

    @JsonProperty(value="remoteNetworkId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRemoteNetworkId(NetworkId remoteNetworkId) {
        this.remoteNetworkId = remoteNetworkId;
    }

    public NetworkConnectionResponse routingPolicy(Map<String, NetworkConnectionRoutingPolicyValue> routingPolicy) {
        this.routingPolicy = routingPolicy;
        return this;
    }

    public NetworkConnectionResponse putRoutingPolicyItem(String key, NetworkConnectionRoutingPolicyValue routingPolicyItem) {
        if (this.routingPolicy == null) {
            this.routingPolicy = new HashMap<String, NetworkConnectionRoutingPolicyValue>();
        }
        this.routingPolicy.put(key, routingPolicyItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="routingPolicy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Map<String, NetworkConnectionRoutingPolicyValue> getRoutingPolicy() {
        return this.routingPolicy;
    }

    @JsonProperty(value="routingPolicy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoutingPolicy(Map<String, NetworkConnectionRoutingPolicyValue> routingPolicy) {
        this.routingPolicy = routingPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkConnectionResponse networkConnectionResponse = (NetworkConnectionResponse)o;
        return Objects.equals(this.id, networkConnectionResponse.id) && Objects.equals(this.localChannel, networkConnectionResponse.localChannel) && Objects.equals(this.remoteChannel, networkConnectionResponse.remoteChannel) && Objects.equals((Object)this.status, (Object)networkConnectionResponse.status) && Objects.equals(this.localNetworkId, networkConnectionResponse.localNetworkId) && Objects.equals(this.remoteNetworkId, networkConnectionResponse.remoteNetworkId) && Objects.equals(this.routingPolicy, networkConnectionResponse.routingPolicy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.localChannel, this.remoteChannel, this.status, this.localNetworkId, this.remoteNetworkId, this.routingPolicy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetworkConnectionResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    localChannel: ").append(this.toIndentedString(this.localChannel)).append("\n");
        sb.append("    remoteChannel: ").append(this.toIndentedString(this.remoteChannel)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    localNetworkId: ").append(this.toIndentedString(this.localNetworkId)).append("\n");
        sb.append("    remoteNetworkId: ").append(this.toIndentedString(this.remoteNetworkId)).append("\n");
        sb.append("    routingPolicy: ").append(this.toIndentedString(this.routingPolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getLocalChannel() != null) {
            joiner.add(this.getLocalChannel().toUrlQueryString((String)prefix + JSON_PROPERTY_LOCAL_CHANNEL + suffix));
        }
        if (this.getRemoteChannel() != null) {
            joiner.add(this.getRemoteChannel().toUrlQueryString((String)prefix + JSON_PROPERTY_REMOTE_CHANNEL + suffix));
        }
        if (this.getStatus() != null) {
            joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getLocalNetworkId() != null) {
            joiner.add(this.getLocalNetworkId().toUrlQueryString((String)prefix + JSON_PROPERTY_LOCAL_NETWORK_ID + suffix));
        }
        if (this.getRemoteNetworkId() != null) {
            joiner.add(this.getRemoteNetworkId().toUrlQueryString((String)prefix + JSON_PROPERTY_REMOTE_NETWORK_ID + suffix));
        }
        if (this.getRoutingPolicy() != null) {
            for (String _key : this.getRoutingPolicy().keySet()) {
                if (this.getRoutingPolicy().get(_key) == null) continue;
                joiner.add(this.getRoutingPolicy().get(_key).toUrlQueryString(String.format("%sroutingPolicy%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

