/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.NetworkIdRoutingPolicyValue;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"routingPolicy", "isDiscoverable", "id", "name"})
public class NetworkIdResponse {
    public static final String JSON_PROPERTY_ROUTING_POLICY = "routingPolicy";
    private Map<String, NetworkIdRoutingPolicyValue> routingPolicy = new HashMap<String, NetworkIdRoutingPolicyValue>();
    public static final String JSON_PROPERTY_IS_DISCOVERABLE = "isDiscoverable";
    private Boolean isDiscoverable;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public NetworkIdResponse routingPolicy(Map<String, NetworkIdRoutingPolicyValue> routingPolicy) {
        this.routingPolicy = routingPolicy;
        return this;
    }

    public NetworkIdResponse putRoutingPolicyItem(String key, NetworkIdRoutingPolicyValue routingPolicyItem) {
        if (this.routingPolicy == null) {
            this.routingPolicy = new HashMap<String, NetworkIdRoutingPolicyValue>();
        }
        this.routingPolicy.put(key, routingPolicyItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="routingPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, NetworkIdRoutingPolicyValue> getRoutingPolicy() {
        return this.routingPolicy;
    }

    @JsonProperty(value="routingPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoutingPolicy(Map<String, NetworkIdRoutingPolicyValue> routingPolicy) {
        this.routingPolicy = routingPolicy;
    }

    public NetworkIdResponse isDiscoverable(Boolean isDiscoverable) {
        this.isDiscoverable = isDiscoverable;
        return this;
    }

    @Nullable
    @JsonProperty(value="isDiscoverable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsDiscoverable() {
        return this.isDiscoverable;
    }

    @JsonProperty(value="isDiscoverable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsDiscoverable(Boolean isDiscoverable) {
        this.isDiscoverable = isDiscoverable;
    }

    public NetworkIdResponse id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public NetworkIdResponse name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkIdResponse networkIdResponse = (NetworkIdResponse)o;
        return Objects.equals(this.routingPolicy, networkIdResponse.routingPolicy) && Objects.equals(this.isDiscoverable, networkIdResponse.isDiscoverable) && Objects.equals(this.id, networkIdResponse.id) && Objects.equals(this.name, networkIdResponse.name);
    }

    public int hashCode() {
        return Objects.hash(this.routingPolicy, this.isDiscoverable, this.id, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetworkIdResponse {\n");
        sb.append("    routingPolicy: ").append(this.toIndentedString(this.routingPolicy)).append("\n");
        sb.append("    isDiscoverable: ").append(this.toIndentedString(this.isDiscoverable)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getRoutingPolicy() != null) {
            for (String _key : this.getRoutingPolicy().keySet()) {
                if (this.getRoutingPolicy().get(_key) == null) continue;
                joiner.add(this.getRoutingPolicy().get(_key).toUrlQueryString(String.format("%sroutingPolicy%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getIsDiscoverable() != null) {
            joiner.add(String.format("%sisDiscoverable%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIsDiscoverable()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

