/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"statusCode", "message", "error"})
public class NotFoundException {
    public static final String JSON_PROPERTY_STATUS_CODE = "statusCode";
    private Integer statusCode;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_ERROR = "error";
    private String error;

    public NotFoundException statusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="statusCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @JsonProperty(value="statusCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public NotFoundException message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessage(String message) {
        this.message = message;
    }

    public NotFoundException error(String error) {
        this.error = error;
        return this;
    }

    @Nullable
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setError(String error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotFoundException notFoundException = (NotFoundException)o;
        return Objects.equals(this.statusCode, notFoundException.statusCode) && Objects.equals(this.message, notFoundException.message) && Objects.equals(this.error, notFoundException.error);
    }

    public int hashCode() {
        return Objects.hash(this.statusCode, this.message, this.error);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotFoundException {\n");
        sb.append("    statusCode: ").append(this.toIndentedString(this.statusCode)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getStatusCode() != null) {
            joiner.add(String.format("%sstatusCode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStatusCode()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getMessage() != null) {
            joiner.add(String.format("%smessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getMessage()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getError() != null) {
            joiner.add(String.format("%serror%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getError()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

