/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "description", "internalType", "type", "components"})
public class Parameter {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_INTERNAL_TYPE = "internalType";
    private String internalType;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_COMPONENTS = "components";
    private List<Parameter> components;

    public Parameter name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public Parameter description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public Parameter internalType(String internalType) {
        this.internalType = internalType;
        return this;
    }

    @Nullable
    @JsonProperty(value="internalType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInternalType() {
        return this.internalType;
    }

    @JsonProperty(value="internalType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalType(String internalType) {
        this.internalType = internalType;
    }

    public Parameter type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public Parameter components(List<Parameter> components) {
        this.components = components;
        return this;
    }

    public Parameter addComponentsItem(Parameter componentsItem) {
        if (this.components == null) {
            this.components = new ArrayList<Parameter>();
        }
        this.components.add(componentsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="components")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Parameter> getComponents() {
        return this.components;
    }

    @JsonProperty(value="components")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComponents(List<Parameter> components) {
        this.components = components;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        return Objects.equals(this.name, parameter.name) && Objects.equals(this.description, parameter.description) && Objects.equals(this.internalType, parameter.internalType) && Objects.equals(this.type, parameter.type) && Objects.equals(this.components, parameter.components);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.internalType, this.type, this.components);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Parameter {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    internalType: ").append(this.toIndentedString(this.internalType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDescription() != null) {
            joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getInternalType() != null) {
            joiner.add(String.format("%sinternalType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getInternalType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getComponents() != null) {
            for (int i = 0; i < this.getComponents().size(); ++i) {
                if (this.getComponents().get(i) == null) continue;
                joiner.add(this.getComponents().get(i).toUrlQueryString(String.format("%scomponents%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

