/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.InstructionAmount;
import com.fireblocks.sdk.model.PayeeAccount;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "payeeAccount", "amount"})
public class PayoutInstruction {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_PAYEE_ACCOUNT = "payeeAccount";
    private PayeeAccount payeeAccount;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private InstructionAmount amount;

    public PayoutInstruction id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public PayoutInstruction payeeAccount(PayeeAccount payeeAccount) {
        this.payeeAccount = payeeAccount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="payeeAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayeeAccount getPayeeAccount() {
        return this.payeeAccount;
    }

    @JsonProperty(value="payeeAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayeeAccount(PayeeAccount payeeAccount) {
        this.payeeAccount = payeeAccount;
    }

    public PayoutInstruction amount(InstructionAmount amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public InstructionAmount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(InstructionAmount amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutInstruction payoutInstruction = (PayoutInstruction)o;
        return Objects.equals(this.id, payoutInstruction.id) && Objects.equals(this.payeeAccount, payoutInstruction.payeeAccount) && Objects.equals(this.amount, payoutInstruction.amount);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.payeeAccount, this.amount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutInstruction {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    payeeAccount: ").append(this.toIndentedString(this.payeeAccount)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPayeeAccount() != null) {
            joiner.add(this.getPayeeAccount().toUrlQueryString((String)prefix + JSON_PROPERTY_PAYEE_ACCOUNT + suffix));
        }
        if (this.getAmount() != null) {
            joiner.add(this.getAmount().toUrlQueryString((String)prefix + JSON_PROPERTY_AMOUNT + suffix));
        }
        return joiner.toString();
    }
}

