/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.InstructionAmount;
import com.fireblocks.sdk.model.PayeeAccountResponse;
import com.fireblocks.sdk.model.PayoutInstructionState;
import com.fireblocks.sdk.model.Transaction;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "payeeAccount", "amount", "state", "transactions"})
public class PayoutInstructionResponse {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_PAYEE_ACCOUNT = "payeeAccount";
    private PayeeAccountResponse payeeAccount;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private InstructionAmount amount;
    public static final String JSON_PROPERTY_STATE = "state";
    private PayoutInstructionState state;
    public static final String JSON_PROPERTY_TRANSACTIONS = "transactions";
    private List<Transaction> transactions = new ArrayList<Transaction>();

    public PayoutInstructionResponse id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public PayoutInstructionResponse payeeAccount(PayeeAccountResponse payeeAccount) {
        this.payeeAccount = payeeAccount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="payeeAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayeeAccountResponse getPayeeAccount() {
        return this.payeeAccount;
    }

    @JsonProperty(value="payeeAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayeeAccount(PayeeAccountResponse payeeAccount) {
        this.payeeAccount = payeeAccount;
    }

    public PayoutInstructionResponse amount(InstructionAmount amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public InstructionAmount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(InstructionAmount amount) {
        this.amount = amount;
    }

    public PayoutInstructionResponse state(PayoutInstructionState state) {
        this.state = state;
        return this;
    }

    @Nonnull
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayoutInstructionState getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setState(PayoutInstructionState state) {
        this.state = state;
    }

    public PayoutInstructionResponse transactions(List<Transaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public PayoutInstructionResponse addTransactionsItem(Transaction transactionsItem) {
        if (this.transactions == null) {
            this.transactions = new ArrayList<Transaction>();
        }
        this.transactions.add(transactionsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="transactions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    @JsonProperty(value="transactions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutInstructionResponse payoutInstructionResponse = (PayoutInstructionResponse)o;
        return Objects.equals(this.id, payoutInstructionResponse.id) && Objects.equals(this.payeeAccount, payoutInstructionResponse.payeeAccount) && Objects.equals(this.amount, payoutInstructionResponse.amount) && Objects.equals((Object)this.state, (Object)payoutInstructionResponse.state) && Objects.equals(this.transactions, payoutInstructionResponse.transactions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.payeeAccount, this.amount, this.state, this.transactions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutInstructionResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    payeeAccount: ").append(this.toIndentedString(this.payeeAccount)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPayeeAccount() != null) {
            joiner.add(this.getPayeeAccount().toUrlQueryString((String)prefix + JSON_PROPERTY_PAYEE_ACCOUNT + suffix));
        }
        if (this.getAmount() != null) {
            joiner.add(this.getAmount().toUrlQueryString((String)prefix + JSON_PROPERTY_AMOUNT + suffix));
        }
        if (this.getState() != null) {
            joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getState()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTransactions() != null) {
            for (int i = 0; i < this.getTransactions().size(); ++i) {
                if (this.getTransactions().get(i) == null) continue;
                joiner.add(this.getTransactions().get(i).toUrlQueryString(String.format("%stransactions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

