/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.PaymentAccountResponse;
import com.fireblocks.sdk.model.PayoutInitMethod;
import com.fireblocks.sdk.model.PayoutInstructionResponse;
import com.fireblocks.sdk.model.PayoutState;
import com.fireblocks.sdk.model.PayoutStatus;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"payoutId", "paymentAccount", "createdAt", "state", "status", "reasonOfFailure", "initMethod", "instructionSet", "reportUrl"})
public class PayoutResponse {
    public static final String JSON_PROPERTY_PAYOUT_ID = "payoutId";
    private String payoutId;
    public static final String JSON_PROPERTY_PAYMENT_ACCOUNT = "paymentAccount";
    private PaymentAccountResponse paymentAccount;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private BigDecimal createdAt;
    public static final String JSON_PROPERTY_STATE = "state";
    private PayoutState state;
    public static final String JSON_PROPERTY_STATUS = "status";
    private PayoutStatus status;
    public static final String JSON_PROPERTY_REASON_OF_FAILURE = "reasonOfFailure";
    private String reasonOfFailure;
    public static final String JSON_PROPERTY_INIT_METHOD = "initMethod";
    private PayoutInitMethod initMethod;
    public static final String JSON_PROPERTY_INSTRUCTION_SET = "instructionSet";
    private List<PayoutInstructionResponse> instructionSet = new ArrayList<PayoutInstructionResponse>();
    public static final String JSON_PROPERTY_REPORT_URL = "reportUrl";
    private String reportUrl;

    public PayoutResponse payoutId(String payoutId) {
        this.payoutId = payoutId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="payoutId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPayoutId() {
        return this.payoutId;
    }

    @JsonProperty(value="payoutId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayoutId(String payoutId) {
        this.payoutId = payoutId;
    }

    public PayoutResponse paymentAccount(PaymentAccountResponse paymentAccount) {
        this.paymentAccount = paymentAccount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="paymentAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PaymentAccountResponse getPaymentAccount() {
        return this.paymentAccount;
    }

    @JsonProperty(value="paymentAccount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPaymentAccount(PaymentAccountResponse paymentAccount) {
        this.paymentAccount = paymentAccount;
    }

    public PayoutResponse createdAt(BigDecimal createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(BigDecimal createdAt) {
        this.createdAt = createdAt;
    }

    public PayoutResponse state(PayoutState state) {
        this.state = state;
        return this;
    }

    @Nonnull
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayoutState getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setState(PayoutState state) {
        this.state = state;
    }

    public PayoutResponse status(PayoutStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayoutStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(PayoutStatus status) {
        this.status = status;
    }

    public PayoutResponse reasonOfFailure(String reasonOfFailure) {
        this.reasonOfFailure = reasonOfFailure;
        return this;
    }

    @Nullable
    @JsonProperty(value="reasonOfFailure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReasonOfFailure() {
        return this.reasonOfFailure;
    }

    @JsonProperty(value="reasonOfFailure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReasonOfFailure(String reasonOfFailure) {
        this.reasonOfFailure = reasonOfFailure;
    }

    public PayoutResponse initMethod(PayoutInitMethod initMethod) {
        this.initMethod = initMethod;
        return this;
    }

    @Nullable
    @JsonProperty(value="initMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PayoutInitMethod getInitMethod() {
        return this.initMethod;
    }

    @JsonProperty(value="initMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitMethod(PayoutInitMethod initMethod) {
        this.initMethod = initMethod;
    }

    public PayoutResponse instructionSet(List<PayoutInstructionResponse> instructionSet) {
        this.instructionSet = instructionSet;
        return this;
    }

    public PayoutResponse addInstructionSetItem(PayoutInstructionResponse instructionSetItem) {
        if (this.instructionSet == null) {
            this.instructionSet = new ArrayList<PayoutInstructionResponse>();
        }
        this.instructionSet.add(instructionSetItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="instructionSet")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<PayoutInstructionResponse> getInstructionSet() {
        return this.instructionSet;
    }

    @JsonProperty(value="instructionSet")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInstructionSet(List<PayoutInstructionResponse> instructionSet) {
        this.instructionSet = instructionSet;
    }

    public PayoutResponse reportUrl(String reportUrl) {
        this.reportUrl = reportUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="reportUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReportUrl() {
        return this.reportUrl;
    }

    @JsonProperty(value="reportUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReportUrl(String reportUrl) {
        this.reportUrl = reportUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutResponse payoutResponse = (PayoutResponse)o;
        return Objects.equals(this.payoutId, payoutResponse.payoutId) && Objects.equals(this.paymentAccount, payoutResponse.paymentAccount) && Objects.equals(this.createdAt, payoutResponse.createdAt) && Objects.equals((Object)this.state, (Object)payoutResponse.state) && Objects.equals((Object)this.status, (Object)payoutResponse.status) && Objects.equals(this.reasonOfFailure, payoutResponse.reasonOfFailure) && Objects.equals((Object)this.initMethod, (Object)payoutResponse.initMethod) && Objects.equals(this.instructionSet, payoutResponse.instructionSet) && Objects.equals(this.reportUrl, payoutResponse.reportUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.payoutId, this.paymentAccount, this.createdAt, this.state, this.status, this.reasonOfFailure, this.initMethod, this.instructionSet, this.reportUrl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutResponse {\n");
        sb.append("    payoutId: ").append(this.toIndentedString(this.payoutId)).append("\n");
        sb.append("    paymentAccount: ").append(this.toIndentedString(this.paymentAccount)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    reasonOfFailure: ").append(this.toIndentedString(this.reasonOfFailure)).append("\n");
        sb.append("    initMethod: ").append(this.toIndentedString((Object)this.initMethod)).append("\n");
        sb.append("    instructionSet: ").append(this.toIndentedString(this.instructionSet)).append("\n");
        sb.append("    reportUrl: ").append(this.toIndentedString(this.reportUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getPayoutId() != null) {
            joiner.add(String.format("%spayoutId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPayoutId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPaymentAccount() != null) {
            joiner.add(this.getPaymentAccount().toUrlQueryString((String)prefix + JSON_PROPERTY_PAYMENT_ACCOUNT + suffix));
        }
        if (this.getCreatedAt() != null) {
            joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCreatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getState() != null) {
            joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getState()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatus() != null) {
            joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getReasonOfFailure() != null) {
            joiner.add(String.format("%sreasonOfFailure%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getReasonOfFailure()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getInitMethod() != null) {
            joiner.add(String.format("%sinitMethod%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getInitMethod()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getInstructionSet() != null) {
            for (int i = 0; i < this.getInstructionSet().size(); ++i) {
                if (this.getInstructionSet().get(i) == null) continue;
                joiner.add(this.getInstructionSet().get(i).toUrlQueryString(String.format("%sinstructionSet%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getReportUrl() != null) {
            joiner.add(String.format("%sreportUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getReportUrl()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

