/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fireblocks.sdk.model.PolicyRuleCheckResult;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"errors", "results"})
public class PolicyCheckResult {
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private BigDecimal errors;
    public static final String JSON_PROPERTY_RESULTS = "results";
    private List<PolicyRuleCheckResult> results = new ArrayList<PolicyRuleCheckResult>();

    public PolicyCheckResult errors(BigDecimal errors) {
        this.errors = errors;
        return this;
    }

    @Nonnull
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getErrors() {
        return this.errors;
    }

    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setErrors(BigDecimal errors) {
        this.errors = errors;
    }

    public PolicyCheckResult results(List<PolicyRuleCheckResult> results) {
        this.results = results;
        return this;
    }

    public PolicyCheckResult addResultsItem(PolicyRuleCheckResult resultsItem) {
        if (this.results == null) {
            this.results = new ArrayList<PolicyRuleCheckResult>();
        }
        this.results.add(resultsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="results")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<PolicyRuleCheckResult> getResults() {
        return this.results;
    }

    @JsonProperty(value="results")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResults(List<PolicyRuleCheckResult> results) {
        this.results = results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyCheckResult policyCheckResult = (PolicyCheckResult)o;
        return Objects.equals(this.errors, policyCheckResult.errors) && Objects.equals(this.results, policyCheckResult.results);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.results);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyCheckResult {\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getErrors() != null) {
            joiner.add(String.format("%serrors%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getErrors()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getResults() != null) {
            for (int i = 0; i < this.getResults().size(); ++i) {
                if (this.getResults().get(i) == null) continue;
                joiner.add(this.getResults().get(i).toUrlQueryString(String.format("%sresults%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

