/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fireblocks.sdk.model.PolicyRuleError;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"index", "status", "errors"})
public class PolicyRuleCheckResult {
    public static final String JSON_PROPERTY_INDEX = "index";
    private BigDecimal index;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private List<PolicyRuleError> errors = new ArrayList<PolicyRuleError>();

    public PolicyRuleCheckResult index(BigDecimal index) {
        this.index = index;
        return this;
    }

    @Nonnull
    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getIndex() {
        return this.index;
    }

    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIndex(BigDecimal index) {
        this.index = index;
    }

    public PolicyRuleCheckResult status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public PolicyRuleCheckResult errors(List<PolicyRuleError> errors) {
        this.errors = errors;
        return this;
    }

    public PolicyRuleCheckResult addErrorsItem(PolicyRuleError errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<PolicyRuleError>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<PolicyRuleError> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setErrors(List<PolicyRuleError> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyRuleCheckResult policyRuleCheckResult = (PolicyRuleCheckResult)o;
        return Objects.equals(this.index, policyRuleCheckResult.index) && Objects.equals((Object)this.status, (Object)policyRuleCheckResult.status) && Objects.equals(this.errors, policyRuleCheckResult.errors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.index, this.status, this.errors});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyRuleCheckResult {\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getIndex() != null) {
            joiner.add(String.format("%sindex%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIndex()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatus() != null) {
            joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getStatus()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getErrors() != null) {
            for (int i = 0; i < this.getErrors().size(); ++i) {
                if (this.getErrors().get(i) == null) continue;
                joiner.add(this.getErrors().get(i).toUrlQueryString(String.format("%serrors%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }

    public static enum StatusEnum {
        OK("ok"),
        FAILURE("failure");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

