/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"errorMessage", "errorCode", "errorCodeName", "errorField"})
public class PolicyRuleError {
    public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
    private String errorMessage;
    public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
    private BigDecimal errorCode;
    public static final String JSON_PROPERTY_ERROR_CODE_NAME = "errorCodeName";
    private String errorCodeName;
    public static final String JSON_PROPERTY_ERROR_FIELD = "errorField";
    private ErrorFieldEnum errorField;

    public PolicyRuleError errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nonnull
    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public PolicyRuleError errorCode(BigDecimal errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Nonnull
    @JsonProperty(value="errorCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty(value="errorCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setErrorCode(BigDecimal errorCode) {
        this.errorCode = errorCode;
    }

    public PolicyRuleError errorCodeName(String errorCodeName) {
        this.errorCodeName = errorCodeName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="errorCodeName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getErrorCodeName() {
        return this.errorCodeName;
    }

    @JsonProperty(value="errorCodeName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setErrorCodeName(String errorCodeName) {
        this.errorCodeName = errorCodeName;
    }

    public PolicyRuleError errorField(ErrorFieldEnum errorField) {
        this.errorField = errorField;
        return this;
    }

    @Nonnull
    @JsonProperty(value="errorField")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ErrorFieldEnum getErrorField() {
        return this.errorField;
    }

    @JsonProperty(value="errorField")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setErrorField(ErrorFieldEnum errorField) {
        this.errorField = errorField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyRuleError policyRuleError = (PolicyRuleError)o;
        return Objects.equals(this.errorMessage, policyRuleError.errorMessage) && Objects.equals(this.errorCode, policyRuleError.errorCode) && Objects.equals(this.errorCodeName, policyRuleError.errorCodeName) && Objects.equals((Object)this.errorField, (Object)policyRuleError.errorField);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.errorMessage, this.errorCode, this.errorCodeName, this.errorField});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyRuleError {\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorCodeName: ").append(this.toIndentedString(this.errorCodeName)).append("\n");
        sb.append("    errorField: ").append(this.toIndentedString((Object)this.errorField)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getErrorMessage() != null) {
            joiner.add(String.format("%serrorMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getErrorMessage()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getErrorCode() != null) {
            joiner.add(String.format("%serrorCode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getErrorCode()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getErrorCodeName() != null) {
            joiner.add(String.format("%serrorCodeName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getErrorCodeName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getErrorField() != null) {
            joiner.add(String.format("%serrorField%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getErrorField()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum ErrorFieldEnum {
        OPERATOR("operator"),
        OPERATORS("operators"),
        AUTHORIZATIONGROUPS("authorizationGroups"),
        DESIGNATEDSIGNER("designatedSigner"),
        DESIGNATEDSIGNERS("designatedSigners"),
        CONTRACTMETHODS("contractMethods"),
        AMOUNTAGGREGATION("amountAggregation"),
        SRC("src"),
        DST("dst");

        private String value;

        private ErrorFieldEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ErrorFieldEnum fromValue(String value) {
            for (ErrorFieldEnum b : ErrorFieldEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

