/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"algorithm", "derivationPath", "publicKey"})
public class PublicKeyInformation {
    public static final String JSON_PROPERTY_ALGORITHM = "algorithm";
    private String algorithm;
    public static final String JSON_PROPERTY_DERIVATION_PATH = "derivationPath";
    private List<BigDecimal> derivationPath;
    public static final String JSON_PROPERTY_PUBLIC_KEY = "publicKey";
    private String publicKey;

    public PublicKeyInformation algorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @Nullable
    @JsonProperty(value="algorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="algorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public PublicKeyInformation derivationPath(List<BigDecimal> derivationPath) {
        this.derivationPath = derivationPath;
        return this;
    }

    public PublicKeyInformation addDerivationPathItem(BigDecimal derivationPathItem) {
        if (this.derivationPath == null) {
            this.derivationPath = new ArrayList<BigDecimal>();
        }
        this.derivationPath.add(derivationPathItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="derivationPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BigDecimal> getDerivationPath() {
        return this.derivationPath;
    }

    @JsonProperty(value="derivationPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDerivationPath(List<BigDecimal> derivationPath) {
        this.derivationPath = derivationPath;
    }

    public PublicKeyInformation publicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="publicKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicKey() {
        return this.publicKey;
    }

    @JsonProperty(value="publicKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyInformation publicKeyInformation = (PublicKeyInformation)o;
        return Objects.equals(this.algorithm, publicKeyInformation.algorithm) && Objects.equals(this.derivationPath, publicKeyInformation.derivationPath) && Objects.equals(this.publicKey, publicKeyInformation.publicKey);
    }

    public int hashCode() {
        return Objects.hash(this.algorithm, this.derivationPath, this.publicKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PublicKeyInformation {\n");
        sb.append("    algorithm: ").append(this.toIndentedString(this.algorithm)).append("\n");
        sb.append("    derivationPath: ").append(this.toIndentedString(this.derivationPath)).append("\n");
        sb.append("    publicKey: ").append(this.toIndentedString(this.publicKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAlgorithm() != null) {
            joiner.add(String.format("%salgorithm%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAlgorithm()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDerivationPath() != null) {
            for (int i = 0; i < this.getDerivationPath().size(); ++i) {
                if (this.getDerivationPath().get(i) == null) continue;
                joiner.add(String.format("%sderivationPath%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getDerivationPath().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getPublicKey() != null) {
            joiner.add(String.format("%spublicKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPublicKey()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

