/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"blockchainId", "address", "symbol"})
public class RegisterNewAssetRequest {
    public static final String JSON_PROPERTY_BLOCKCHAIN_ID = "blockchainId";
    private String blockchainId;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private String address;
    public static final String JSON_PROPERTY_SYMBOL = "symbol";
    private String symbol;

    public RegisterNewAssetRequest blockchainId(String blockchainId) {
        this.blockchainId = blockchainId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="blockchainId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBlockchainId() {
        return this.blockchainId;
    }

    @JsonProperty(value="blockchainId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBlockchainId(String blockchainId) {
        this.blockchainId = blockchainId;
    }

    public RegisterNewAssetRequest address(String address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(String address) {
        this.address = address;
    }

    public RegisterNewAssetRequest symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nullable
    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSymbol() {
        return this.symbol;
    }

    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisterNewAssetRequest registerNewAssetRequest = (RegisterNewAssetRequest)o;
        return Objects.equals(this.blockchainId, registerNewAssetRequest.blockchainId) && Objects.equals(this.address, registerNewAssetRequest.address) && Objects.equals(this.symbol, registerNewAssetRequest.symbol);
    }

    public int hashCode() {
        return Objects.hash(this.blockchainId, this.address, this.symbol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RegisterNewAssetRequest {\n");
        sb.append("    blockchainId: ").append(this.toIndentedString(this.blockchainId)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getBlockchainId() != null) {
            joiner.add(String.format("%sblockchainId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBlockchainId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAddress() != null) {
            joiner.add(String.format("%saddress%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAddress()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSymbol() != null) {
            joiner.add(String.format("%ssymbol%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSymbol()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

