/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"txHash", "assetId"})
public class RescanTransaction {
    public static final String JSON_PROPERTY_TX_HASH = "txHash";
    private String txHash;
    public static final String JSON_PROPERTY_ASSET_ID = "assetId";
    private String assetId;

    public RescanTransaction txHash(String txHash) {
        this.txHash = txHash;
        return this;
    }

    @Nullable
    @JsonProperty(value="txHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTxHash() {
        return this.txHash;
    }

    @JsonProperty(value="txHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public RescanTransaction assetId(String assetId) {
        this.assetId = assetId;
        return this;
    }

    @Nullable
    @JsonProperty(value="assetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAssetId() {
        return this.assetId;
    }

    @JsonProperty(value="assetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RescanTransaction rescanTransaction = (RescanTransaction)o;
        return Objects.equals(this.txHash, rescanTransaction.txHash) && Objects.equals(this.assetId, rescanTransaction.assetId);
    }

    public int hashCode() {
        return Objects.hash(this.txHash, this.assetId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RescanTransaction {\n");
        sb.append("    txHash: ").append(this.toIndentedString(this.txHash)).append("\n");
        sb.append("    assetId: ").append(this.toIndentedString(this.assetId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTxHash() != null) {
            joiner.add(String.format("%stxHash%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTxHash()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAssetId() != null) {
            joiner.add(String.format("%sassetId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAssetId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

