/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fireblocks.sdk.model.Destination;
import com.fireblocks.sdk.model.ScreeningVerdictMatchedRule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"verdict", "executionOperationId", "account", "assetId", "amount", "matchedRule"})
public class ScreeningVerdict {
    public static final String JSON_PROPERTY_VERDICT = "verdict";
    private VerdictEnum verdict;
    public static final String JSON_PROPERTY_EXECUTION_OPERATION_ID = "executionOperationId";
    private String executionOperationId;
    public static final String JSON_PROPERTY_ACCOUNT = "account";
    private Destination account;
    public static final String JSON_PROPERTY_ASSET_ID = "assetId";
    private String assetId;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private String amount;
    public static final String JSON_PROPERTY_MATCHED_RULE = "matchedRule";
    private ScreeningVerdictMatchedRule matchedRule;

    public ScreeningVerdict verdict(VerdictEnum verdict) {
        this.verdict = verdict;
        return this;
    }

    @Nonnull
    @JsonProperty(value="verdict")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public VerdictEnum getVerdict() {
        return this.verdict;
    }

    @JsonProperty(value="verdict")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVerdict(VerdictEnum verdict) {
        this.verdict = verdict;
    }

    public ScreeningVerdict executionOperationId(String executionOperationId) {
        this.executionOperationId = executionOperationId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="executionOperationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExecutionOperationId() {
        return this.executionOperationId;
    }

    @JsonProperty(value="executionOperationId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExecutionOperationId(String executionOperationId) {
        this.executionOperationId = executionOperationId;
    }

    public ScreeningVerdict account(Destination account) {
        this.account = account;
        return this;
    }

    @Nonnull
    @JsonProperty(value="account")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Destination getAccount() {
        return this.account;
    }

    @JsonProperty(value="account")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccount(Destination account) {
        this.account = account;
    }

    public ScreeningVerdict assetId(String assetId) {
        this.assetId = assetId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="assetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAssetId() {
        return this.assetId;
    }

    @JsonProperty(value="assetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public ScreeningVerdict amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(String amount) {
        this.amount = amount;
    }

    public ScreeningVerdict matchedRule(ScreeningVerdictMatchedRule matchedRule) {
        this.matchedRule = matchedRule;
        return this;
    }

    @Nullable
    @JsonProperty(value="matchedRule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScreeningVerdictMatchedRule getMatchedRule() {
        return this.matchedRule;
    }

    @JsonProperty(value="matchedRule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMatchedRule(ScreeningVerdictMatchedRule matchedRule) {
        this.matchedRule = matchedRule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreeningVerdict screeningVerdict = (ScreeningVerdict)o;
        return Objects.equals((Object)this.verdict, (Object)screeningVerdict.verdict) && Objects.equals(this.executionOperationId, screeningVerdict.executionOperationId) && Objects.equals(this.account, screeningVerdict.account) && Objects.equals(this.assetId, screeningVerdict.assetId) && Objects.equals(this.amount, screeningVerdict.amount) && Objects.equals(this.matchedRule, screeningVerdict.matchedRule);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.verdict, this.executionOperationId, this.account, this.assetId, this.amount, this.matchedRule});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScreeningVerdict {\n");
        sb.append("    verdict: ").append(this.toIndentedString((Object)this.verdict)).append("\n");
        sb.append("    executionOperationId: ").append(this.toIndentedString(this.executionOperationId)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    assetId: ").append(this.toIndentedString(this.assetId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    matchedRule: ").append(this.toIndentedString(this.matchedRule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getVerdict() != null) {
            joiner.add(String.format("%sverdict%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getVerdict()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getExecutionOperationId() != null) {
            joiner.add(String.format("%sexecutionOperationId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getExecutionOperationId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAccount() != null) {
            joiner.add(this.getAccount().toUrlQueryString((String)prefix + JSON_PROPERTY_ACCOUNT + suffix));
        }
        if (this.getAssetId() != null) {
            joiner.add(String.format("%sassetId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAssetId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAmount() != null) {
            joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getMatchedRule() != null) {
            joiner.add(this.getMatchedRule().toUrlQueryString((String)prefix + JSON_PROPERTY_MATCHED_RULE + suffix));
        }
        return joiner.toString();
    }

    public static enum VerdictEnum {
        PASSED("PASSED"),
        PASSED_WITH_ALERT("PASSED_WITH_ALERT"),
        REJECTED("REJECTED"),
        FAILED("FAILED"),
        BYPASSED("BYPASSED");

        private String value;

        private VerdictEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VerdictEnum fromValue(String value) {
            for (VerdictEnum b : VerdictEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

