/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fireblocks.sdk.model.SessionMetadata;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "userId", "sessionMetadata", "vaultAccountId", "feeLevel", "chainIds", "connectionType", "connectionMethod", "creationDate"})
public class SessionDTO {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;
    public static final String JSON_PROPERTY_SESSION_METADATA = "sessionMetadata";
    private SessionMetadata sessionMetadata;
    public static final String JSON_PROPERTY_VAULT_ACCOUNT_ID = "vaultAccountId";
    private BigDecimal vaultAccountId;
    public static final String JSON_PROPERTY_FEE_LEVEL = "feeLevel";
    private FeeLevelEnum feeLevel;
    public static final String JSON_PROPERTY_CHAIN_IDS = "chainIds";
    private List<String> chainIds = new ArrayList<String>();
    public static final String JSON_PROPERTY_CONNECTION_TYPE = "connectionType";
    private ConnectionTypeEnum connectionType;
    public static final String JSON_PROPERTY_CONNECTION_METHOD = "connectionMethod";
    private ConnectionMethodEnum connectionMethod;
    public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
    private OffsetDateTime creationDate;

    public SessionDTO id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public SessionDTO userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public SessionDTO sessionMetadata(SessionMetadata sessionMetadata) {
        this.sessionMetadata = sessionMetadata;
        return this;
    }

    @Nonnull
    @JsonProperty(value="sessionMetadata")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SessionMetadata getSessionMetadata() {
        return this.sessionMetadata;
    }

    @JsonProperty(value="sessionMetadata")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSessionMetadata(SessionMetadata sessionMetadata) {
        this.sessionMetadata = sessionMetadata;
    }

    public SessionDTO vaultAccountId(BigDecimal vaultAccountId) {
        this.vaultAccountId = vaultAccountId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="vaultAccountId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getVaultAccountId() {
        return this.vaultAccountId;
    }

    @JsonProperty(value="vaultAccountId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVaultAccountId(BigDecimal vaultAccountId) {
        this.vaultAccountId = vaultAccountId;
    }

    public SessionDTO feeLevel(FeeLevelEnum feeLevel) {
        this.feeLevel = feeLevel;
        return this;
    }

    @Nonnull
    @JsonProperty(value="feeLevel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FeeLevelEnum getFeeLevel() {
        return this.feeLevel;
    }

    @JsonProperty(value="feeLevel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeeLevel(FeeLevelEnum feeLevel) {
        this.feeLevel = feeLevel;
    }

    public SessionDTO chainIds(List<String> chainIds) {
        this.chainIds = chainIds;
        return this;
    }

    public SessionDTO addChainIdsItem(String chainIdsItem) {
        if (this.chainIds == null) {
            this.chainIds = new ArrayList<String>();
        }
        this.chainIds.add(chainIdsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="chainIds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getChainIds() {
        return this.chainIds;
    }

    @JsonProperty(value="chainIds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChainIds(List<String> chainIds) {
        this.chainIds = chainIds;
    }

    public SessionDTO connectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="connectionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConnectionTypeEnum getConnectionType() {
        return this.connectionType;
    }

    @JsonProperty(value="connectionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConnectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
    }

    public SessionDTO connectionMethod(ConnectionMethodEnum connectionMethod) {
        this.connectionMethod = connectionMethod;
        return this;
    }

    @Nonnull
    @JsonProperty(value="connectionMethod")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConnectionMethodEnum getConnectionMethod() {
        return this.connectionMethod;
    }

    @JsonProperty(value="connectionMethod")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConnectionMethod(ConnectionMethodEnum connectionMethod) {
        this.connectionMethod = connectionMethod;
    }

    public SessionDTO creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionDTO sessionDTO = (SessionDTO)o;
        return Objects.equals(this.id, sessionDTO.id) && Objects.equals(this.userId, sessionDTO.userId) && Objects.equals(this.sessionMetadata, sessionDTO.sessionMetadata) && Objects.equals(this.vaultAccountId, sessionDTO.vaultAccountId) && Objects.equals((Object)this.feeLevel, (Object)sessionDTO.feeLevel) && Objects.equals(this.chainIds, sessionDTO.chainIds) && Objects.equals((Object)this.connectionType, (Object)sessionDTO.connectionType) && Objects.equals((Object)this.connectionMethod, (Object)sessionDTO.connectionMethod) && Objects.equals(this.creationDate, sessionDTO.creationDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.userId, this.sessionMetadata, this.vaultAccountId, this.feeLevel, this.chainIds, this.connectionType, this.connectionMethod, this.creationDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SessionDTO {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    sessionMetadata: ").append(this.toIndentedString(this.sessionMetadata)).append("\n");
        sb.append("    vaultAccountId: ").append(this.toIndentedString(this.vaultAccountId)).append("\n");
        sb.append("    feeLevel: ").append(this.toIndentedString((Object)this.feeLevel)).append("\n");
        sb.append("    chainIds: ").append(this.toIndentedString(this.chainIds)).append("\n");
        sb.append("    connectionType: ").append(this.toIndentedString((Object)this.connectionType)).append("\n");
        sb.append("    connectionMethod: ").append(this.toIndentedString((Object)this.connectionMethod)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUserId() != null) {
            joiner.add(String.format("%suserId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUserId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSessionMetadata() != null) {
            joiner.add(this.getSessionMetadata().toUrlQueryString((String)prefix + JSON_PROPERTY_SESSION_METADATA + suffix));
        }
        if (this.getVaultAccountId() != null) {
            joiner.add(String.format("%svaultAccountId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVaultAccountId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFeeLevel() != null) {
            joiner.add(String.format("%sfeeLevel%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getFeeLevel()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getChainIds() != null) {
            for (int i = 0; i < this.getChainIds().size(); ++i) {
                joiner.add(String.format("%schainIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getChainIds().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getConnectionType() != null) {
            joiner.add(String.format("%sconnectionType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getConnectionType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getConnectionMethod() != null) {
            joiner.add(String.format("%sconnectionMethod%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getConnectionMethod()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCreationDate() != null) {
            joiner.add(String.format("%screationDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCreationDate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum ConnectionMethodEnum {
        DESKTOP("DESKTOP"),
        MOBILE("MOBILE"),
        API("API");

        private String value;

        private ConnectionMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConnectionMethodEnum fromValue(String value) {
            for (ConnectionMethodEnum b : ConnectionMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ConnectionTypeEnum {
        WALLETCONNECT("WalletConnect");

        private String value;

        private ConnectionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConnectionTypeEnum fromValue(String value) {
            for (ConnectionTypeEnum b : ConnectionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FeeLevelEnum {
        MEDIUM("MEDIUM"),
        HIGH("HIGH");

        private String value;

        private FeeLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FeeLevelEnum fromValue(String value) {
            for (FeeLevelEnum b : FeeLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

