/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"appUrl", "appName", "appDescription", "appIcon"})
public class SessionMetadata {
    public static final String JSON_PROPERTY_APP_URL = "appUrl";
    private String appUrl;
    public static final String JSON_PROPERTY_APP_NAME = "appName";
    private String appName;
    public static final String JSON_PROPERTY_APP_DESCRIPTION = "appDescription";
    private String appDescription;
    public static final String JSON_PROPERTY_APP_ICON = "appIcon";
    private String appIcon;

    public SessionMetadata appUrl(String appUrl) {
        this.appUrl = appUrl;
        return this;
    }

    @Nonnull
    @JsonProperty(value="appUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAppUrl() {
        return this.appUrl;
    }

    @JsonProperty(value="appUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public SessionMetadata appName(String appName) {
        this.appName = appName;
        return this;
    }

    @Nullable
    @JsonProperty(value="appName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAppName() {
        return this.appName;
    }

    @JsonProperty(value="appName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppName(String appName) {
        this.appName = appName;
    }

    public SessionMetadata appDescription(String appDescription) {
        this.appDescription = appDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="appDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAppDescription() {
        return this.appDescription;
    }

    @JsonProperty(value="appDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppDescription(String appDescription) {
        this.appDescription = appDescription;
    }

    public SessionMetadata appIcon(String appIcon) {
        this.appIcon = appIcon;
        return this;
    }

    @Nullable
    @JsonProperty(value="appIcon")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAppIcon() {
        return this.appIcon;
    }

    @JsonProperty(value="appIcon")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppIcon(String appIcon) {
        this.appIcon = appIcon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionMetadata sessionMetadata = (SessionMetadata)o;
        return Objects.equals(this.appUrl, sessionMetadata.appUrl) && Objects.equals(this.appName, sessionMetadata.appName) && Objects.equals(this.appDescription, sessionMetadata.appDescription) && Objects.equals(this.appIcon, sessionMetadata.appIcon);
    }

    public int hashCode() {
        return Objects.hash(this.appUrl, this.appName, this.appDescription, this.appIcon);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SessionMetadata {\n");
        sb.append("    appUrl: ").append(this.toIndentedString(this.appUrl)).append("\n");
        sb.append("    appName: ").append(this.toIndentedString(this.appName)).append("\n");
        sb.append("    appDescription: ").append(this.toIndentedString(this.appDescription)).append("\n");
        sb.append("    appIcon: ").append(this.toIndentedString(this.appIcon)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAppUrl() != null) {
            joiner.add(String.format("%sappUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAppUrl()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAppName() != null) {
            joiner.add(String.format("%sappName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAppName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAppDescription() != null) {
            joiner.add(String.format("%sappDescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAppDescription()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAppIcon() != null) {
            joiner.add(String.format("%sappIcon%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAppIcon()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

