/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"currency", "price"})
public class SetAssetPriceRequest {
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_PRICE = "price";
    private BigDecimal price;

    public SetAssetPriceRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nonnull
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public SetAssetPriceRequest price(BigDecimal price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetAssetPriceRequest setAssetPriceRequest = (SetAssetPriceRequest)o;
        return Objects.equals(this.currency, setAssetPriceRequest.currency) && Objects.equals(this.price, setAssetPriceRequest.price);
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.price);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetAssetPriceRequest {\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCurrency() != null) {
            joiner.add(String.format("%scurrency%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCurrency()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPrice() != null) {
            joiner.add(String.format("%sprice%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPrice()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

