/*
 * Decompiled with CFR 0.152.
 */
package com.fireblocks.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fireblocks.sdk.model.SignedMessageSignature;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"content", "algorithm", "derivationPath", "signature", "publicKey"})
public class SignedMessage {
    public static final String JSON_PROPERTY_CONTENT = "content";
    private String content;
    public static final String JSON_PROPERTY_ALGORITHM = "algorithm";
    private AlgorithmEnum algorithm;
    public static final String JSON_PROPERTY_DERIVATION_PATH = "derivationPath";
    private List<BigDecimal> derivationPath;
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    private SignedMessageSignature signature;
    public static final String JSON_PROPERTY_PUBLIC_KEY = "publicKey";
    private String publicKey;

    public SignedMessage content(String content) {
        this.content = content;
        return this;
    }

    @Nullable
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContent(String content) {
        this.content = content;
    }

    public SignedMessage algorithm(AlgorithmEnum algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @Nullable
    @JsonProperty(value="algorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AlgorithmEnum getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="algorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlgorithm(AlgorithmEnum algorithm) {
        this.algorithm = algorithm;
    }

    public SignedMessage derivationPath(List<BigDecimal> derivationPath) {
        this.derivationPath = derivationPath;
        return this;
    }

    public SignedMessage addDerivationPathItem(BigDecimal derivationPathItem) {
        if (this.derivationPath == null) {
            this.derivationPath = new ArrayList<BigDecimal>();
        }
        this.derivationPath.add(derivationPathItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="derivationPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BigDecimal> getDerivationPath() {
        return this.derivationPath;
    }

    @JsonProperty(value="derivationPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDerivationPath(List<BigDecimal> derivationPath) {
        this.derivationPath = derivationPath;
    }

    public SignedMessage signature(SignedMessageSignature signature) {
        this.signature = signature;
        return this;
    }

    @Nullable
    @JsonProperty(value="signature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SignedMessageSignature getSignature() {
        return this.signature;
    }

    @JsonProperty(value="signature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignature(SignedMessageSignature signature) {
        this.signature = signature;
    }

    public SignedMessage publicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="publicKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicKey() {
        return this.publicKey;
    }

    @JsonProperty(value="publicKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignedMessage signedMessage = (SignedMessage)o;
        return Objects.equals(this.content, signedMessage.content) && Objects.equals((Object)this.algorithm, (Object)signedMessage.algorithm) && Objects.equals(this.derivationPath, signedMessage.derivationPath) && Objects.equals(this.signature, signedMessage.signature) && Objects.equals(this.publicKey, signedMessage.publicKey);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.content, this.algorithm, this.derivationPath, this.signature, this.publicKey});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignedMessage {\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    algorithm: ").append(this.toIndentedString((Object)this.algorithm)).append("\n");
        sb.append("    derivationPath: ").append(this.toIndentedString(this.derivationPath)).append("\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    publicKey: ").append(this.toIndentedString(this.publicKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getContent() != null) {
            joiner.add(String.format("%scontent%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getContent()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAlgorithm() != null) {
            joiner.add(String.format("%salgorithm%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getAlgorithm()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDerivationPath() != null) {
            for (int i = 0; i < this.getDerivationPath().size(); ++i) {
                if (this.getDerivationPath().get(i) == null) continue;
                joiner.add(String.format("%sderivationPath%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getDerivationPath().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getSignature() != null) {
            joiner.add(this.getSignature().toUrlQueryString((String)prefix + JSON_PROPERTY_SIGNATURE + suffix));
        }
        if (this.getPublicKey() != null) {
            joiner.add(String.format("%spublicKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPublicKey()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum AlgorithmEnum {
        ECDSA_SECP256K1("MPC_ECDSA_SECP256K1"),
        EDDSA_ED25519("MPC_EDDSA_ED25519");

        private String value;

        private AlgorithmEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AlgorithmEnum fromValue(String value) {
            for (AlgorithmEnum b : AlgorithmEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

